/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.LineBuffer;

public class NegatorHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;

    public NegatorHdlGeneratorFactory() {
        this.myParametersList.addBusOnly(NR_OF_BITS_STRING, -1);
        this.myPorts.add("input", "dataX", -1, 0, StdAttr.WIDTH).add("output", "minDataX", -1, 1, StdAttr.WIDTH);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        if (Hdl.isVhdl()) {
            int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
            contents.empty().addVhdlKeywords().add(nrOfBits == 1 ? "minDataX <= dataX;" : "minDataX <= std_logic_vector(unsigned({{not}}(dataX)) + 1);");
        } else {
            contents.add("assign minDataX = -dataX;");
        }
        return contents.empty();
    }
}

