/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.base;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.base.Text;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TextAttributes
extends AbstractAttributeSet {
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(Text.ATTR_TEXT, Text.ATTR_FONT, Text.ATTR_COLOR, Text.ATTR_HALIGN, Text.ATTR_VALIGN);
    private String text = "";
    private Font font = StdAttr.DEFAULT_LABEL_FONT;
    private Color color = Color.BLACK;
    private AttributeOption halign = Text.ATTR_HALIGN.parse("center");
    private AttributeOption valign = Text.ATTR_VALIGN.parse("base");
    private Bounds offsetBounds = null;

    @Override
    protected void copyInto(AbstractAttributeSet destObj) {
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    Font getFont() {
        return this.font;
    }

    int getHorizontalAlign() {
        return (Integer)this.halign.getValue();
    }

    Bounds getOffsetBounds() {
        return this.offsetBounds;
    }

    String getText() {
        return this.text;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == Text.ATTR_TEXT) {
            return (V)this.text;
        }
        if (attr == Text.ATTR_FONT) {
            return (V)this.font;
        }
        if (attr == Text.ATTR_HALIGN) {
            return (V)this.halign;
        }
        if (attr == Text.ATTR_VALIGN) {
            return (V)this.valign;
        }
        if (attr == Text.ATTR_COLOR) {
            return (V)this.color;
        }
        return null;
    }

    int getVerticalAlign() {
        return (Integer)this.valign.getValue();
    }

    boolean setOffsetBounds(Bounds value) {
        Bounds old = this.offsetBounds;
        boolean same = Objects.equals(old, value);
        if (!same) {
            this.offsetBounds = value;
        }
        return !same;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == Text.ATTR_TEXT) {
            this.text = (String)value;
        } else if (attr == Text.ATTR_FONT) {
            this.font = (Font)value;
        } else if (attr == Text.ATTR_HALIGN) {
            this.halign = (AttributeOption)value;
        } else if (attr == Text.ATTR_VALIGN) {
            this.valign = (AttributeOption)value;
        } else if (attr == Text.ATTR_COLOR) {
            this.color = (Color)value;
        } else {
            throw new IllegalArgumentException("unknown attribute");
        }
        this.offsetBounds = null;
        this.fireAttributeValueChanged(attr, value, null);
    }
}

