/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.GateAttributeList;
import com.cburch.logisim.std.gates.NegateAttribute;
import java.awt.Font;
import java.util.List;

public class GateAttributes
extends AbstractAttributeSet {
    static final int MAX_INPUTS = 64;
    static final int DELAY = 1;
    static final AttributeOption SIZE_NARROW = new AttributeOption(30, Strings.S.getter("gateSizeNarrowOpt"));
    static final AttributeOption SIZE_MEDIUM = new AttributeOption(50, Strings.S.getter("gateSizeNormalOpt"));
    static final AttributeOption SIZE_WIDE = new AttributeOption(70, Strings.S.getter("gateSizeWideOpt"));
    public static final Attribute<AttributeOption> ATTR_SIZE = Attributes.forOption("size", Strings.S.getter("gateSizeAttr"), new AttributeOption[]{SIZE_NARROW, SIZE_MEDIUM, SIZE_WIDE});
    public static final Attribute<Integer> ATTR_INPUTS = Attributes.forIntegerRange("inputs", Strings.S.getter("gateInputsAttr"), 2, 64);
    static final AttributeOption XOR_ONE = new AttributeOption("1", Strings.S.getter("xorBehaviorOne"));
    static final AttributeOption XOR_ODD = new AttributeOption("odd", Strings.S.getter("xorBehaviorOdd"));
    public static final Attribute<AttributeOption> ATTR_XOR = Attributes.forOption("xor", Strings.S.getter("xorBehaviorAttr"), new AttributeOption[]{XOR_ONE, XOR_ODD});
    static final AttributeOption OUTPUT_01 = new AttributeOption("01", Strings.S.getter("gateOutput01"));
    static final AttributeOption OUTPUT_0Z = new AttributeOption("0Z", Strings.S.getter("gateOutput0Z"));
    static final AttributeOption OUTPUT_Z1 = new AttributeOption("Z1", Strings.S.getter("gateOutputZ1"));
    public static final Attribute<AttributeOption> ATTR_OUTPUT = Attributes.forOption("out", Strings.S.getter("gateOutputAttr"), new AttributeOption[]{OUTPUT_01, OUTPUT_0Z, OUTPUT_Z1});
    Direction facing = Direction.EAST;
    BitWidth width = BitWidth.ONE;
    AttributeOption size = SIZE_MEDIUM;
    int inputs = 2;
    long negated = 0L;
    AttributeOption out = OUTPUT_01;
    AttributeOption xorBehave;
    String label = "";
    Font labelFont = StdAttr.DEFAULT_LABEL_FONT;

    GateAttributes(boolean isXor) {
        this.xorBehave = isXor ? XOR_ONE : null;
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return new GateAttributeList(this);
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == StdAttr.FACING) {
            return (V)this.facing;
        }
        if (attr == StdAttr.WIDTH) {
            return (V)this.width;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == ATTR_SIZE) {
            return (V)this.size;
        }
        if (attr == ATTR_INPUTS) {
            return (V)Integer.valueOf(this.inputs);
        }
        if (attr == ATTR_OUTPUT) {
            return (V)this.out;
        }
        if (attr == ATTR_XOR) {
            return (V)this.xorBehave;
        }
        if (attr instanceof NegateAttribute) {
            NegateAttribute negAttr = (NegateAttribute)attr;
            int index = negAttr.index;
            int bit = (int)(this.negated >> index) & 1;
            return (V)Boolean.valueOf(bit == 1);
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        String oldvalue = "";
        if (attr == StdAttr.WIDTH) {
            this.width = (BitWidth)value;
            int bits = this.width.getWidth();
            long mask = bits >= 64 ? -1L : (1L << this.inputs) - 1L;
            this.negated &= mask;
        } else if (attr == StdAttr.FACING) {
            this.facing = (Direction)value;
        } else if (attr == StdAttr.LABEL) {
            String val = (String)value;
            oldvalue = this.label;
            this.label = val;
        } else if (attr == StdAttr.LABEL_FONT) {
            this.labelFont = (Font)value;
        } else if (attr == ATTR_SIZE) {
            this.size = (AttributeOption)value;
        } else if (attr == ATTR_INPUTS) {
            this.inputs = (Integer)value;
            this.fireAttributeListChanged();
        } else if (attr == ATTR_XOR) {
            this.xorBehave = (AttributeOption)value;
        } else if (attr == ATTR_OUTPUT) {
            this.out = (AttributeOption)value;
        } else if (attr instanceof NegateAttribute) {
            NegateAttribute negAttr = (NegateAttribute)attr;
            int index = negAttr.index;
            this.negated = ((Boolean)value).booleanValue() ? (this.negated |= (long)(1 << index)) : (this.negated &= (long)(~(1 << index)));
        } else {
            throw new IllegalArgumentException("unrecognized argument");
        }
        this.fireAttributeValueChanged(attr, value, attr == StdAttr.LABEL ? oldvalue : null);
    }
}

