/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;

class OddParityGate
extends AbstractGate {
    public static final OddParityGate FACTORY = new OddParityGate();
    private final String ODD_PARITY_LABEL = "2k+1";

    private OddParityGate() {
        super("Odd Parity", Strings.S.getter("oddParityComponent"), new XorGateHdlGeneratorFactory());
        this.setRectangularLabel("2k+1");
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        Expression ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = Expressions.xor(ret, inputs[i]);
        }
        return ret;
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        return GateFunctions.computeOddParity(inputs, numInputs);
    }

    @Override
    protected Value getIdentity() {
        return Value.FALSE;
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        this.paintRectangular(painter, width, height);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        this.paintRectangular(painter, width, height);
    }

    @Override
    protected void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        AbstractGate.paintIconIEC(g, "2k+1", false, false);
    }

    private static class XorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private XorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            return LineBuffer.getBuffer().add(XorGateHdlGeneratorFactory.getParity(false, nrOfInputs, bitwidth > 1));
        }
    }
}

