/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.JoystickIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class Joystick
extends InstanceFactory {
    public static final String _ID = "Joystick";
    static final Attribute<BitWidth> ATTR_WIDTH = Attributes.forBitWidth("bits", Strings.S.getter("ioBitWidthAttr"), 2, 5);

    private static void drawBall(Graphics g, int x, int y, Color c, boolean inColor) {
        if (inColor) {
            g.setColor(c == null ? Color.RED : c);
        } else {
            int hue = c == null ? 128 : (c.getRed() + c.getGreen() + c.getBlue()) / 3;
            g.setColor(new Color(hue, hue, hue));
        }
        GraphicsUtil.switchToWidth(g, 1);
        g.fillOval(x - 4, y - 4, 8, 8);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawOval(x - 4, y - 4, 8, 8);
    }

    public Joystick() {
        super(_ID, Strings.S.getter("joystickComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FACING, ATTR_WIDTH, IoLibrary.ATTR_COLOR, IoLibrary.ATTR_BACKGROUND}, new Object[]{Direction.EAST, BitWidth.create(4), Color.RED, IoLibrary.DEFAULT_BACKGROUND});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(ATTR_WIDTH, 2, 5));
        this.setOffsetBounds(Bounds.create(-30, -10, 30, 30));
        this.setIcon(new JoystickIcon());
        this.setPorts(new Port[]{new Port(0, 0, "output", ATTR_WIDTH), new Port(0, 10, "output", ATTR_WIDTH)});
        this.setInstancePoker(Poker.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.updatePorts(instance);
        instance.addAttributeListener();
    }

    private void updatePorts(Instance instance) {
        int y1;
        int x1;
        int y0;
        int x0;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        if (facing == Direction.NORTH) {
            x0 = -20;
            y0 = -10;
            x1 = -10;
            y1 = -10;
        } else if (facing == Direction.SOUTH) {
            x0 = -20;
            y0 = 20;
            x1 = -10;
            y1 = 20;
        } else if (facing == Direction.WEST) {
            x0 = -30;
            y0 = 0;
            x1 = -30;
            y1 = 10;
        } else {
            x0 = 0;
            y0 = 0;
            x1 = 0;
            y1 = 10;
        }
        Port[] ports = new Port[2];
        ports[0] = new Port(x0, y0, "output", ATTR_WIDTH);
        ports[0].setToolTip(Strings.S.getter("joystickCoordinateX"));
        ports[1] = new Port(x1, y1, "output", ATTR_WIDTH);
        ports[1].setToolTip(Strings.S.getter("joystickCoordinateY"));
        instance.setPorts(ports);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRoundRect(-30, -10, 30, 30, 8, 8);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        Graphics g = painter.getGraphics();
        g.setColor(painter.getAttributeValue(IoLibrary.ATTR_BACKGROUND));
        g.fillRoundRect(x - 30, y - 10, 30, 30, 8, 8);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawRoundRect(x - 30, y - 10, 30, 30, 8, 8);
        g.drawRoundRect(x - 28, y - 8, 26, 26, 4, 4);
        Joystick.drawBall(g, x - 15, y + 5, painter.getAttributeValue(IoLibrary.ATTR_COLOR), painter.shouldDrawColor());
        painter.drawPorts();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            this.updatePorts(instance);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        int dy;
        int dx;
        BitWidth bits = state.getAttributeValue(ATTR_WIDTH);
        State s = (State)state.getData();
        if (s == null) {
            dx = 0;
            dy = 0;
        } else {
            dx = s.xPos;
            dy = s.yPos;
        }
        int steps = (1 << bits.getWidth()) - 1;
        dx = (dx + 14) * steps / 29 + 1;
        dy = (dy + 14) * steps / 29 + 1;
        if (bits.getWidth() > 4) {
            if (dx >= steps / 2) {
                ++dx;
            }
            if (dy >= steps / 2) {
                ++dy;
            }
        }
        state.setPort(0, Value.createKnown(bits, (long)dx), 1);
        state.setPort(1, Value.createKnown(bits, (long)dy), 1);
    }

    public static class Poker
    extends InstancePoker {
        @Override
        public void mouseDragged(InstanceState state, MouseEvent e) {
            Location loc = state.getInstance().getLocation();
            int cx = loc.getX() - 15;
            int cy = loc.getY() + 5;
            this.updateState(state, e.getX() - cx, e.getY() - cy);
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.mouseDragged(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            this.updateState(state, 0, 0);
        }

        @Override
        public void paint(InstancePainter painter) {
            State state = (State)painter.getData();
            if (state == null) {
                state = new State(0, 0);
                painter.setData(state);
            }
            Location loc = painter.getLocation();
            int x = loc.getX();
            int y = loc.getY();
            Graphics g = painter.getGraphics();
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
            g.fillOval(x - 19, y + 1, 8, 8);
            GraphicsUtil.switchToWidth(g, 3);
            int dx = state.xPos;
            int dy = state.yPos;
            int x0 = x - 15 + (dx > 5 ? 1 : (dx < -5 ? -1 : 0));
            int y0 = y + 5 + (dy > 5 ? 1 : (dy < 0 ? -1 : 0));
            int x1 = x - 15 + dx;
            int y1 = y + 5 + dy;
            g.drawLine(x0, y0, x1, y1);
            Color ballColor = painter.getAttributeValue(IoLibrary.ATTR_COLOR);
            Joystick.drawBall(g, x1, y1, ballColor, true);
        }

        private void updateState(InstanceState state, int dx, int dy) {
            State s = (State)state.getData();
            if (dx < -14) {
                dx = -14;
            }
            if (dy < -14) {
                dy = -14;
            }
            if (dx > 14) {
                dx = 14;
            }
            if (dy > 14) {
                dy = 14;
            }
            if (s == null) {
                s = new State(dx, dy);
                state.setData(s);
            } else {
                s.xPos = dx;
                s.yPos = dy;
            }
            state.getInstance().fireInvalidated();
        }
    }

    private static class State
    implements InstanceData,
    Cloneable {
        private int xPos;
        private int yPos;

        public State(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

