/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.KeyboardIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.KeyboardData;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

public class Keyboard
extends InstanceFactory {
    public static final String _ID = "Keyboard";
    private static final int CLR = 0;
    private static final int CK = 1;
    private static final int RE = 2;
    private static final int AVL = 3;
    private static final int OUT = 4;
    private static final int DELAY0 = 9;
    private static final int DELAY1 = 11;
    static final int WIDTH = 145;
    static final int HEIGHT = 25;
    private static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final char FORM_FEED = '\f';
    private static final Attribute<Integer> ATTR_BUFFER = Attributes.forIntegerRange("buflen", Strings.S.getter("keybBufferLengthAttr"), 1, 256);

    public static void addToBuffer(InstanceState state, char[] newChars) {
        KeyboardData keyboardData = Keyboard.getKeyboardState(state);
        for (char newChar : newChars) {
            keyboardData.insert(newChar);
        }
    }

    private static int getBufferLength(Object bufferAttr) {
        return bufferAttr instanceof Integer ? (Integer)bufferAttr : 32;
    }

    private static KeyboardData getKeyboardState(InstanceState state) {
        int bufLen = Keyboard.getBufferLength(state.getAttributeValue(ATTR_BUFFER));
        KeyboardData ret = (KeyboardData)state.getData();
        if (ret == null) {
            ret = new KeyboardData(bufLen);
            state.setData(ret);
        } else {
            ret.updateBufferLength(bufLen);
        }
        return ret;
    }

    public Keyboard() {
        super(_ID, Strings.S.getter("keyboardComponent"));
        this.setAttributes(new Attribute[]{ATTR_BUFFER, StdAttr.EDGE_TRIGGER}, new Object[]{32, StdAttr.TRIG_RISING});
        this.setOffsetBounds(Bounds.create(0, -15, 145, 25));
        this.setIcon(new KeyboardIcon());
        this.setInstancePoker(Poker.class);
        Port[] ps = new Port[]{new Port(20, 10, "input", 1), new Port(0, 0, "input", 1), new Port(10, 10, "input", 1), new Port(130, 10, "output", 1), new Port(140, 10, "output", 7)};
        ps[0].setToolTip(Strings.S.getter("keybClearTip"));
        ps[1].setToolTip(Strings.S.getter("keybClockTip"));
        ps[2].setToolTip(Strings.S.getter("keybEnableTip"));
        ps[3].setToolTip(Strings.S.getter("keybAvailTip"));
        ps[4].setToolTip(Strings.S.getter("keybOutputTip"));
        this.setPorts(ps);
    }

    private void drawBuffer(Graphics g, FontMetrics fm, String str, int dispStart, int dispEnd, ArrayList<Integer> specials, Bounds bds) {
        int xs;
        int x = bds.getX();
        int y = bds.getY();
        g.setFont(DEFAULT_FONT);
        if (fm == null) {
            fm = g.getFontMetrics();
        }
        int asc = fm.getAscent();
        int x0 = x + 8;
        int ys = y + (25 + asc) / 2;
        int dotsWidth = fm.stringWidth("m");
        if (dispStart > 0) {
            g.drawString(str.substring(0, 1), x0, ys);
            xs = x0 + fm.stringWidth(str.charAt(0) + "m");
            this.drawDots(g, xs - dotsWidth, ys, dotsWidth, asc);
            String sub = str.substring(dispStart, dispEnd);
            g.drawString(sub, xs, ys);
            if (dispEnd < str.length()) {
                this.drawDots(g, xs + fm.stringWidth(sub), ys, dotsWidth, asc);
            }
        } else if (dispEnd < str.length()) {
            String sub = str.substring(dispStart, dispEnd);
            xs = x0;
            g.drawString(sub, xs, ys);
            this.drawDots(g, xs + fm.stringWidth(sub), ys, dotsWidth, asc);
        } else {
            xs = x0;
            g.drawString(str, xs, ys);
        }
        if (specials.size() > 0) {
            this.drawSpecials(specials, x0, xs, ys, asc, g, fm, str, dispStart, dispEnd);
        }
    }

    private void drawDots(Graphics g, int x, int y, int width, int ascent) {
        int d;
        int r = width / 10;
        if (r < 1) {
            r = 1;
        }
        if (2 * r + 1 * (d = 2 * r) <= width) {
            g.fillOval(x + r, y - d, d, d);
        }
        if (3 * r + 2 * d <= width) {
            g.fillOval(x + 2 * r + d, y - d, d, d);
        }
        if (5 * r + 3 * d <= width) {
            g.fillOval(x + 3 * r + 2 * d, y - d, d, d);
        }
    }

    private void drawSpecials(ArrayList<Integer> specials, int x0, int xs, int ys, int asc, Graphics g, FontMetrics fm, String str, int dispStart, int dispEnd) {
        int[] px = new int[3];
        int[] py = new int[3];
        for (Integer special : specials) {
            int y1;
            int w1;
            int w0;
            Integer code = special;
            int pos = code & 0xFF;
            if (pos == 0) {
                w0 = x0;
                w1 = x0 + fm.stringWidth(str.substring(0, 1));
            } else {
                if (pos < dispStart || pos >= dispEnd) continue;
                w0 = xs + fm.stringWidth(str.substring(dispStart, pos));
                w1 = xs + fm.stringWidth(str.substring(dispStart, pos + 1));
            }
            ++w0;
            --w1;
            int key = code >> 16;
            if (key == 8) {
                y1 = ys - asc / 2;
                g.drawLine(w0, y1, w1, y1);
                px[0] = w0 + 3;
                py[0] = y1 - 3;
                px[1] = w0;
                py[1] = y1;
                px[2] = w0 + 3;
                py[2] = y1 + 3;
                g.drawPolyline(px, py, 3);
                continue;
            }
            if (key == 10) {
                y1 = ys - 3;
                px[0] = w1;
                py[0] = ys - asc;
                px[1] = w1;
                py[1] = y1;
                px[2] = w0;
                py[2] = y1;
                g.drawPolyline(px, py, 3);
                px[0] = w0 + 3;
                py[0] = y1 - 3;
                px[1] = w0;
                py[1] = y1;
                px[2] = w0 + 3;
                py[2] = y1 + 3;
                g.drawPolyline(px, py, 3);
                continue;
            }
            if (key != 12) continue;
            g.drawRect(w0, ys - asc, w1 - w0, asc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintInstance(InstancePainter painter) {
        boolean showState = painter.getShowState();
        Graphics g = painter.getGraphics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawClock(1, Direction.EAST);
        painter.drawBounds();
        painter.drawPort(0);
        painter.drawPort(2);
        painter.drawPort(3);
        painter.drawPort(4);
        if (showState) {
            int dispEnd;
            int dispStart;
            String str;
            KeyboardData state;
            ArrayList<Integer> specials = new ArrayList<Integer>();
            FontMetrics fm = null;
            KeyboardData keyboardData = state = Keyboard.getKeyboardState(painter);
            synchronized (keyboardData) {
                str = state.toString();
                int i = state.getNextSpecial(0);
                while (i >= 0) {
                    char c = state.getChar(i);
                    specials.add(c << 16 | i);
                    i = state.getNextSpecial(i + 1);
                }
                if (!state.isDisplayValid()) {
                    fm = g.getFontMetrics(DEFAULT_FONT);
                    state.updateDisplay(fm);
                }
                dispStart = state.getDisplayStart();
                dispEnd = state.getDisplayEnd();
            }
            if (str.length() > 0) {
                Bounds bds = painter.getBounds();
                this.drawBuffer(g, fm, str, dispStart, dispEnd, specials, bds);
            }
        } else {
            Bounds bds = painter.getBounds();
            int len = Keyboard.getBufferLength(painter.getAttributeValue(ATTR_BUFFER));
            String str = Strings.S.get("keybDesc", "" + len);
            FontMetrics fm = g.getFontMetrics();
            int x = bds.getX() + (145 - fm.stringWidth(str)) / 2;
            int y = bds.getY() + (25 + fm.getAscent()) / 2;
            g.drawString(str, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(InstanceState circState) {
        char c;
        AttributeOption trigger = circState.getAttributeValue(StdAttr.EDGE_TRIGGER);
        KeyboardData state = Keyboard.getKeyboardState(circState);
        Value clear = circState.getPortValue(0);
        Value clock = circState.getPortValue(1);
        Value enable = circState.getPortValue(2);
        KeyboardData keyboardData = state;
        synchronized (keyboardData) {
            Value lastClock = state.setLastClock(clock);
            if (clear == Value.TRUE) {
                state.clear();
            } else if (enable != Value.FALSE) {
                boolean go;
                boolean bl = trigger == StdAttr.TRIG_FALLING ? lastClock == Value.TRUE && clock == Value.FALSE : (go = lastClock == Value.FALSE && clock == Value.TRUE);
                if (go) {
                    state.dequeue();
                }
            }
            c = state.getChar(0);
        }
        Value out = Value.createKnown(BitWidth.create(7), (long)(c & 0x7F));
        circState.setPort(4, out, 9);
        circState.setPort(3, c != '\u0000' ? Value.TRUE : Value.FALSE, 11);
    }

    public static class Poker
    extends InstancePoker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(InstancePainter painter) {
            int dispStart;
            int cursor;
            String str;
            KeyboardData data = Keyboard.getKeyboardState(painter);
            Bounds bds = painter.getInstance().getBounds();
            Graphics g = painter.getGraphics();
            FontMetrics fm = g.getFontMetrics(DEFAULT_FONT);
            KeyboardData keyboardData = data;
            synchronized (keyboardData) {
                str = data.toString();
                cursor = data.getCursorPosition();
                if (!data.isDisplayValid()) {
                    data.updateDisplay(fm);
                }
                dispStart = data.getDisplayStart();
            }
            int asc = fm.getAscent();
            int x = bds.getX() + 8;
            if (dispStart > 0) {
                x += fm.stringWidth(str.charAt(0) + "m");
                x += fm.stringWidth(str.substring(dispStart, cursor));
            } else {
                x = cursor >= str.length() ? (x += fm.stringWidth(str)) : (x += fm.stringWidth(str.substring(0, cursor)));
            }
            int y = bds.getY() + (bds.getHeight() + asc) / 2;
            g.drawLine(x, y - asc, x, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(InstanceState state, KeyEvent e) {
            KeyboardData data = Keyboard.getKeyboardState(state);
            boolean changed = false;
            boolean used = true;
            KeyboardData keyboardData = data;
            synchronized (keyboardData) {
                switch (e.getKeyCode()) {
                    case 127: {
                        changed = data.delete();
                        break;
                    }
                    case 37: {
                        data.moveCursorBy(-1);
                        break;
                    }
                    case 39: {
                        data.moveCursorBy(1);
                        break;
                    }
                    case 36: {
                        data.setCursor(0);
                        break;
                    }
                    case 35: {
                        data.setCursor(Integer.MAX_VALUE);
                        break;
                    }
                    default: {
                        used = false;
                    }
                }
            }
            if (used) {
                e.consume();
            }
            if (changed) {
                state.getInstance().fireInvalidated();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(InstanceState state, KeyEvent e) {
            KeyboardData data = Keyboard.getKeyboardState(state);
            char ch = e.getKeyChar();
            boolean changed = false;
            if (!(ch == '\uffff' || Character.isISOControl(ch) && ch != '\b' && ch != '\n' && ch != '\f')) {
                KeyboardData keyboardData = data;
                synchronized (keyboardData) {
                    changed = data.insert(ch);
                }
                e.consume();
            }
            if (changed) {
                state.getInstance().fireInvalidated();
            }
        }
    }
}

