/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;

public class LedArrayColumnScanningHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final int NR_OF_LEDS_ID = -1;
    public static final int NR_OF_ROWS_ID = -2;
    public static final int NR_OF_COLUMNS_ID = -3;
    public static final int NR_OF_COLUMN_ADDRESS_BITS_ID = -4;
    public static final int ACTIVE_LOW_ID = -5;
    public static final int SCANNING_COUNTER_BITS_ID = -6;
    public static final int MAX_NR_LEDS_ID = -7;
    public static final int SCANNING_COUNTER_VALUE_ID = -8;
    public static final String NR_OF_ROWS_STRING = "nrOfRows";
    public static final String NR_OF_COLUMNS_STRING = "nrOfColumns";
    public static final String NR_OF_LEDS_STRING = "nrOfLeds";
    public static final String NR_OF_COLUMN_ADDRESS_BITS_STRING = "nrOfColumnAddressBits";
    public static final String SCANNING_COUNTER_BITS_STRING = "nrOfScanningCounterBits";
    public static final String SCANNING_COUNTER_VALUE_STRING = "scanningCounterReloadValue";
    public static final String MAX_NR_LEDS_STRING = "maxNrLedsAddrColumns";
    public static final String ACTIVE_LOW_STRING = "activeLow";
    public static final String HDL_IDENTIFIER = "LedArrayColumnScanning";

    public LedArrayColumnScanningHdlGeneratorFactory() {
        this.myParametersList.add(ACTIVE_LOW_STRING, -5).add(MAX_NR_LEDS_STRING, -7).add(NR_OF_COLUMNS_STRING, -3).add(NR_OF_COLUMN_ADDRESS_BITS_STRING, -4).add(NR_OF_LEDS_STRING, -1).add(NR_OF_ROWS_STRING, -2).add(SCANNING_COUNTER_BITS_STRING, -6).add(SCANNING_COUNTER_VALUE_STRING, -8);
        this.myWires.addWire("s_columnCounterNext", -4).addWire("s_scanningCounterNext", -6).addWire("s_tickNext", 1).addWire("s_maxLedInputs", -7).addRegister("s_columnCounterReg", -4).addRegister("s_scanningCounterReg", -6).addRegister("s_tickReg", 1);
        this.myPorts.add("input", "fpgaGlobalClock", 1, 0).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, -1, 1).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, -4, 2).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowOutputs, -2, 3);
    }

    public static LineBuffer getGenericMap(int nrOfRows, int nrOfColumns, long fpgaClockFrequency, boolean activeLow) {
        int nrColAddrBits = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(nrOfColumns);
        int scanningReload = (int)(fpgaClockFrequency / 1000L);
        int nrOfScanningBitsCount = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(scanningReload);
        int maxNrLeds = (int)Math.pow(2.0, nrColAddrBits) * nrOfRows;
        HashMap<String, String> generics = new HashMap<String, String>();
        generics.put(NR_OF_LEDS_STRING, Integer.toString(nrOfRows * nrOfColumns));
        generics.put(MAX_NR_LEDS_STRING, Integer.toString(maxNrLeds));
        generics.put(NR_OF_ROWS_STRING, Integer.toString(nrOfRows));
        generics.put(NR_OF_COLUMNS_STRING, Integer.toString(nrOfColumns));
        generics.put(ACTIVE_LOW_STRING, activeLow ? "1" : "0");
        generics.put(NR_OF_COLUMN_ADDRESS_BITS_STRING, Integer.toString(nrColAddrBits));
        generics.put(SCANNING_COUNTER_BITS_STRING, Integer.toString(nrOfScanningBitsCount));
        generics.put(SCANNING_COUNTER_VALUE_STRING, Integer.toString(scanningReload - 1));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(generics, true);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowOutputs, id));
        ports.put("fpgaGlobalClock", "fpgaGlobalClock");
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    public static List<String> getColumnCounterCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("columnAddress", LedArrayGenericHdlGeneratorFactory.LedArrayColumnAddress).pair("clock", "fpgaGlobalClock").pair("counterBits", SCANNING_COUNTER_BITS_STRING).pair("counterValue", SCANNING_COUNTER_VALUE_STRING);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("\n{{columnAddress}} <= s_columnCounterReg;\n\ns_tickNext <= '1' {{when}} s_scanningCounterReg = std_logic_vector(to_unsigned(0, {{counterBits}})) {{else}} '0';\n\ns_scanningCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                         std_logic_vector(to_unsigned({{counterValue}}-1, {{counterBits}}))\n                            {{when}} s_scanningCounterReg = std_logic_vector(to_unsigned(0, {{counterBits}})) {{else}}\n                         std_logic_vector(unsigned(s_scanningCounterReg)-1);\n\ns_columnCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                       s_columnCounterReg {{when}} s_tickReg = '0' ELSE\n                       std_logic_vector(to_unsigned(nrOfColumns-1,nrOfcolumnAddressBits))\n                          {{when}} s_columnCounterReg = std_logic_vector(to_unsigned(0,nrOfColumnAddressBits)) {{else}}\n                       std_logic_vector(unsigned(s_columnCounterReg)-1);\n\nmakeFlops : {{process}} ({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      s_columnCounterReg   <= s_columnCounterNext;\n      s_scanningCounterReg <= s_scanningCounterNext;\n      s_tickReg            <= s_tickNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeFlops;\n").empty();
        } else {
            contents.add("\nassign columnAddress = s_columnCounterReg;\n\nassign s_tickNext = (s_scanningCounterReg == 0) ? 1'b1 : 1'b0;\nassign s_scanningCounterNext = (s_scanningCounterReg == 0) ? {{counterValue}} : s_scanningCounterReg - 1;\nassign s_columnCounterNext = (s_tickReg == 1'b0) ? s_columnCounterReg :\n                             (s_columnCounterReg == 0) ? nrOfColumns-1 : s_columnCounterReg-1;\n").addRemarkBlock("Here the simulation only initial is defined").add("initial\nbegin\n   s_columnCounterReg   = 0;\n   s_scanningCounterReg = 0;\n   s_tickReg            = 1'b0;\nend\n\nalways @(posedge {{clock}})\nbegin\n    s_columnCounterReg   = s_columnCounterNext;\n    s_scanningCounterReg = s_scanningCounterNext;\n    s_tickReg            = s_tickNext;\nend\n");
        }
        return contents.get();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("ins", LedArrayGenericHdlGeneratorFactory.LedArrayInputs).pair("outs", LedArrayGenericHdlGeneratorFactory.LedArrayRowOutputs).pair(NR_OF_LEDS_STRING, NR_OF_LEDS_STRING).pair(NR_OF_ROWS_STRING, NR_OF_ROWS_STRING).pair(ACTIVE_LOW_STRING, ACTIVE_LOW_STRING).add(LedArrayColumnScanningHdlGeneratorFactory.getColumnCounterCode());
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("makeVirtualInputs : {{process}} ( internalLeds ) {{is}}\n{{begin}}\n   s_maxLedInputs <= ({{others}} => '0');\n   {{if}} ({{activeLow}} = 1) {{then}}\n      s_maxLedInputs( {{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{ins}};\n   {{else}}\n      s_maxLedInputs( {{nrOfLeds}}-1 {{downto}} 0) <= {{ins}};\n   {{end}} {{if}};\n{{end}} {{process}} makeVirtualInputs;\n\ngenOutputs : {{for}} n {{in}} {{nrOfRows}}-1 {{downto}} 0 {{generate}}\n   {{outs}}(n) <= s_maxLedInputs(to_integer(unsigned(s_columnCounterReg)) + n*nrOfColumns);\n{{end}} {{generate}} genOutputs;\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < {{nrOfRows}}; i = i + 1)\n   begin: outputs\n      assign {{outs}}[i] = (activeLow == 1)\n          ? ~{{ins}}[i * nrOfColumns + s_columnCounterReg]\n          :  {{ins}}[i * nrOfColumns + s_columnCounterReg];\n   end\nendgenerate\n").empty();
        }
        return contents;
    }
}

