/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.std.io.LedArrayLedDefaultHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class RgbArrayLedDefaultHdlGeneratorFactory
extends LedArrayLedDefaultHdlGeneratorFactory {
    public static final String HDL_IDENTIFIER = "RGBArrayLedDefault";

    public RgbArrayLedDefaultHdlGeneratorFactory() {
        this.myPorts.removePorts();
        this.myPorts.add("input", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, -1, 0).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, -1, 1).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, -1, 2).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRedOutputs, -1, 3).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayGreenOutputs, -1, 4).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayBlueOutputs, -1, 5);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRedOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRedOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayGreenOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayGreenOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayBlueOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayBlueOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("outsR", LedArrayGenericHdlGeneratorFactory.LedArrayRedOutputs).pair("outsG", LedArrayGenericHdlGeneratorFactory.LedArrayGreenOutputs).pair("outsB", LedArrayGenericHdlGeneratorFactory.LedArrayBlueOutputs).pair("insR", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs).pair("insG", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs).pair("insB", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs).pair("clock", "fpgaGlobalClock");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("genLeds : {{for}} n {{in}} (nrOfLeds-1) {{downto}} 0 {{generate}}\n   {{outsR}}(n) <= {{not}}({{insR}}(n)) {{when}} activeLow = 1 {{else}} {{insR}}(n);\n   {{outsG}}(n) <= {{not}}({{insG}}(n)) {{when}} activeLow = 1 {{else}} {{insG}}(n);\n   {{outsB}}(n) <= {{not}}({{insB}}(n)) {{when}} activeLow = 1 {{else}} {{insB}}(n);\n{{end}} {{generate}};\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < nrOfLeds; i = i + 1)\n   begin:outputs\n      assign {{outsR}}[i] = (activeLow == 1) ? ~{{insR}}[n] : {{insR}}[n];\n      assign {{outsG}}[i] = (activeLow == 1) ? ~{{insG}}[n] : {{insG}}[n];\n      assign {{outsB}}[i] = (activeLow == 1) ? ~{{insB}}[n] : {{insB}}[n];\n   end\nendgenerate\n").empty();
        }
        return contents;
    }
}

