/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.extra.PlaRomPanel;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Arrays;
import javax.swing.JScrollPane;

public class PlaRomData
implements InstanceData {
    private byte inputs;
    private byte outputs;
    private byte and;
    private String savedData = "";
    private boolean[][] inputAnd;
    private boolean[][] andOutput;
    public int rowHovered = -1;
    public int columnHovered = 0;
    private Value[] inputValue;
    private Value[] andValue;
    private Value[] outputValue;
    private final String[] options = new String[]{new LocaleManager("resources/logisim", "gui").get("saveOption"), Strings.S.get("ramClearMenuItem")};
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private JScrollPane panel;
    private PlaRomPanel drawing;

    public PlaRomData(byte inputs, byte outputs, byte and) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.and = and;
        this.inputAnd = new boolean[this.getAnd()][this.getInputs() * 2];
        this.andOutput = new boolean[this.getAnd()][this.getOutputs()];
        this.inputValue = new Value[this.getInputs()];
        this.andValue = new Value[this.getAnd()];
        this.outputValue = new Value[this.getOutputs()];
        this.initializeInputValue();
        this.setAndValue();
        this.setOutputValue();
    }

    public void clearMatrixValues() {
        for (byte i = 0; i < this.getAnd(); i = (byte)(i + 1)) {
            for (byte j = 0; j < this.getOutputs(); j = (byte)(j + 1)) {
                this.setAndOutputValue(i, j, false);
            }
            for (int k = 0; k < this.getInputs() * 2; k = (int)((byte)(k + 1))) {
                this.setInputAndValue(i, k, false);
            }
        }
        this.savedData = "";
    }

    @Override
    public PlaRomData clone() {
        try {
            return (PlaRomData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void decodeSavedData(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        String[] datas = str.split(" ");
        int cnt = 0;
        for (String data : datas) {
            byte value;
            if (data.contains("*")) {
                String[] tmp = data.split("\\*");
                for (int j = 0; j < Integer.parseInt(tmp[1]); ++j) {
                    value = (byte)Integer.parseInt(tmp[0]);
                    this.writeData(value, cnt);
                    ++cnt;
                }
                continue;
            }
            value = (byte)Integer.parseInt(data);
            this.writeData(value, cnt);
            ++cnt;
        }
    }

    public int editWindow() {
        this.drawing = new PlaRomPanel(this);
        this.panel = new JScrollPane(this.drawing, 20, 30);
        this.panel.setBorder(null);
        this.panel.getVerticalScrollBar().setUnitIncrement(10);
        if (this.drawing.getPreferredSize().getWidth() >= (double)((int)((double)this.screenSize.width * 0.75))) {
            this.panel.setPreferredSize(new Dimension((int)((double)this.screenSize.width * 0.75), (int)this.panel.getPreferredSize().getHeight()));
        }
        if (this.drawing.getPreferredSize().getHeight() >= (double)((int)((double)this.screenSize.height * 0.75))) {
            this.panel.setPreferredSize(new Dimension((int)this.panel.getPreferredSize().getWidth(), (int)((double)this.screenSize.height * 0.75)));
        }
        int ret = OptionPane.showOptionDialog(null, this.panel, Strings.S.get("PlaEditWindowTitel", this.getSizeString()), 2, -1, null, this.options, null);
        this.saveData();
        return ret;
    }

    public byte getAnd() {
        return this.and;
    }

    public boolean getAndOutputValue(int row, int column) {
        return this.andOutput[row][column];
    }

    public Value getAndValue(byte i) {
        return this.andValue[i];
    }

    public boolean getInputAndValue(int row, int column) {
        return this.inputAnd[row][column];
    }

    public byte getInputs() {
        return this.inputs;
    }

    public Value getInputValue(byte i) {
        return this.inputValue[i];
    }

    public byte getOutputs() {
        return this.outputs;
    }

    public Value getOutputValue(byte i) {
        return this.outputValue[i];
    }

    public Value[] getOutputValues() {
        Value[] outputValueCopy = new Value[this.getOutputs()];
        for (byte i = (byte)(this.getOutputs() - 1); i >= 0; i = (byte)(i - 1)) {
            outputValueCopy[i] = this.outputValue[this.outputValue.length - i - 1];
        }
        return outputValueCopy;
    }

    public String getSavedData() {
        return this.savedData;
    }

    public String getSizeString() {
        return this.getInputs() + 120 + this.getAnd() + "x" + this.getOutputs();
    }

    private void initializeInputValue() {
        for (byte i = 0; i < this.getInputs(); i = (byte)(i + 1)) {
            this.inputValue[i] = Value.UNKNOWN;
        }
    }

    private void saveData() {
        int j;
        char val;
        int column;
        int row;
        int i;
        int size1 = this.getInputs() * this.getAnd();
        int size2 = this.getOutputs() * this.getAnd();
        int count = 0;
        char last = 'x';
        boolean dirty = false;
        StringBuilder data = new StringBuilder();
        for (i = 0; i < size1; ++i) {
            row = i / this.getInputs();
            if (this.inputAnd[row][(column = i - row * this.getInputs()) * 2]) {
                val = '1';
                dirty = true;
            } else if (this.inputAnd[row][column * 2 + 1]) {
                val = '2';
                dirty = true;
            } else {
                val = '0';
            }
            if (val == last) {
                ++count;
            } else if (last == 'x') {
                last = val;
                ++count;
            }
            if (val == last && i != size1 - 1) continue;
            if (count >= 3) {
                data.append(last).append("*").append(count).append(' ');
            } else {
                for (j = 0; j < count; ++j) {
                    data.append(last).append(" ");
                }
            }
            if (val != last && i == size1 - 1) {
                data.append(val).append(" ");
            }
            count = 1;
            last = val;
        }
        last = 'x';
        count = 0;
        for (i = 0; i < size2; ++i) {
            row = i / this.getOutputs();
            if (this.andOutput[row][column = i - row * this.getOutputs()]) {
                val = '1';
                dirty = true;
            } else {
                val = '0';
            }
            if (val == last) {
                ++count;
            } else if (last == 'x') {
                last = val;
                ++count;
            }
            if (val == last && i != size2 - 1) continue;
            if (count >= 3) {
                data.append(last).append("*").append(count).append(' ');
            } else {
                for (j = 0; j < count; ++j) {
                    data.append(last).append(" ");
                }
            }
            if (val != last && i == size2 - 1) {
                data.append(val).append(" ");
            }
            count = 1;
            last = val;
        }
        if (!dirty) {
            data = new StringBuilder();
        }
        this.savedData = data.toString();
    }

    public void setAndOutputValue(int row, int column, boolean b) {
        this.andOutput[row][column] = b;
        this.setAndValue();
        this.setOutputValue();
    }

    private void setAndValue() {
        boolean thereisadot = false;
        for (byte i = 0; i < this.getAnd(); i = (byte)(i + 1)) {
            this.andValue[i] = Value.TRUE;
            for (int j = 0; j < this.getInputs() * 2; j = (int)((byte)(j + 1))) {
                if (!this.getInputAndValue(i, j)) continue;
                thereisadot = true;
                if (j % 2 == 0) {
                    if (!this.getInputValue((byte)(j / 2)).isFullyDefined()) {
                        this.andValue[i] = Value.ERROR;
                        continue;
                    }
                    if (this.getInputValue((byte)(j / 2)) != Value.TRUE) continue;
                    this.andValue[i] = Value.FALSE;
                    break;
                }
                if (j % 2 != 1) continue;
                if (!this.getInputValue((byte)((j - 1) / 2)).isFullyDefined()) {
                    this.andValue[i] = Value.ERROR;
                    continue;
                }
                if (this.getInputValue((byte)((j - 1) / 2)) != Value.FALSE) continue;
                this.andValue[i] = Value.FALSE;
                break;
            }
            if (!thereisadot) {
                this.andValue[i] = Value.ERROR;
            }
            thereisadot = false;
        }
    }

    public void setHovered(int row, int column) {
        this.rowHovered = row;
        this.columnHovered = column;
    }

    public void setInputAndValue(int row, int column, boolean b) {
        this.inputAnd[row][column] = b;
        this.setAndValue();
        this.setOutputValue();
    }

    public void setInputsValue(Value[] inputs) {
        int mininputs = this.getInputs() < inputs.length ? this.getInputs() : inputs.length;
        System.arraycopy(inputs, inputs.length - mininputs, this.inputValue, this.getInputs() - mininputs, mininputs);
        this.setAndValue();
        this.setOutputValue();
    }

    private void setOutputValue() {
        boolean thereisadot = false;
        for (byte i = 0; i < this.getOutputs(); i = (byte)(i + 1)) {
            this.outputValue[i] = Value.FALSE;
            for (byte j = 0; j < this.getAnd(); j = (byte)(j + 1)) {
                if (!this.getAndOutputValue(j, i)) continue;
                this.outputValue[i] = this.outputValue[i].or(this.getAndValue(j));
                thereisadot = true;
            }
            if (!thereisadot) {
                this.outputValue[i] = Value.ERROR;
            }
            thereisadot = false;
        }
    }

    public boolean updateSize(byte inputs, byte outputs, byte and) {
        if (this.inputs != inputs || this.outputs != outputs || this.and != and) {
            byte mininputs = this.getInputs() < inputs ? this.getInputs() : inputs;
            byte minoutputs = this.getOutputs() < outputs ? this.getOutputs() : outputs;
            byte minand = this.getAnd() < and ? this.getAnd() : and;
            this.inputs = inputs;
            this.outputs = outputs;
            this.and = and;
            boolean[][] oldInputAnd = (boolean[][])Arrays.copyOf(this.inputAnd, this.inputAnd.length);
            boolean[][] oldAndOutput = (boolean[][])Arrays.copyOf(this.andOutput, this.andOutput.length);
            this.inputAnd = new boolean[this.getAnd()][this.getInputs() * 2];
            this.andOutput = new boolean[this.getAnd()][this.getOutputs()];
            this.inputValue = new Value[this.getInputs()];
            this.andValue = new Value[this.getAnd()];
            this.outputValue = new Value[this.getOutputs()];
            for (byte i = 0; i < minand; i = (byte)(i + 1)) {
                System.arraycopy(oldInputAnd[i], 0, this.inputAnd[i], 0, mininputs * 2);
                System.arraycopy(oldAndOutput[i], 0, this.andOutput[i], 0, minoutputs);
            }
            this.initializeInputValue();
            this.setAndValue();
            this.setOutputValue();
            this.saveData();
            return true;
        }
        return false;
    }

    private void writeData(byte value, int node) {
        block11: {
            block10: {
                if (node >= this.getInputs() * this.getAnd()) break block10;
                int row = node / this.getInputs();
                int column = node - row * this.getInputs();
                switch (value) {
                    case 0: {
                        this.inputAnd[row][column * 2] = false;
                        this.inputAnd[row][column * 2 + 1] = false;
                        break block11;
                    }
                    case 1: {
                        this.inputAnd[row][column * 2] = true;
                        this.inputAnd[row][column * 2 + 1] = false;
                        break block11;
                    }
                    case 2: {
                        this.inputAnd[row][column * 2] = false;
                        this.inputAnd[row][column * 2 + 1] = true;
                        break block11;
                    }
                    default: {
                        System.err.println("PlaRom: Error in saved data ");
                        return;
                    }
                }
            }
            if (node < this.getInputs() * this.getAnd() + this.getOutputs() * this.getAnd()) {
                int row = (node -= this.getInputs() * this.getAnd()) / this.getOutputs();
                int column = node - row * this.getOutputs();
                switch (value) {
                    case 0: {
                        this.andOutput[row][column] = false;
                        break;
                    }
                    case 1: {
                        this.andOutput[row][column] = true;
                        break;
                    }
                    default: {
                        System.err.println("PlaRom: Error in saved data 2");
                        return;
                    }
                }
            }
        }
    }
}

