/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.std.memory.Counter;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class CounterHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "width";
    private static final int NR_OF_BITS_ID = -1;
    private static final String MAX_VALUE_STRING = "maxVal";
    private static final int MAX_VALUE_ID = -2;
    private static final String INVERT_CLOCK_STRING = "invertClock";
    private static final int INVERT_CLOCK_ID = -3;
    private static final String MODE_STRING = "mode";
    private static final int MODE_ID = -4;
    private static final String LOAD_DATA_INPUT = "loadData";
    private static final String COUNT_DATA_OUTPUT = "countValue";

    public CounterHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STRING, -1).addVector(MAX_VALUE_STRING, -2, 6, Counter.ATTR_MAX).add(INVERT_CLOCK_STRING, -3, 4, StdAttr.EDGE_TRIGGER, AbstractFlipFlopHdlGeneratorFactory.TRIGGER_MAP).add(MODE_STRING, -4, 4, Counter.ATTR_ON_GOAL, new HashMap<AttributeOption, Integer>(){
            {
                this.put(Counter.ON_GOAL_WRAP, 0);
                this.put(Counter.ON_GOAL_STAY, 1);
                this.put(Counter.ON_GOAL_CONT, 2);
                this.put(Counter.ON_GOAL_LOAD, 3);
            }
        });
        this.myWires.addWire("s_clock", 1).addWire("s_realEnable", 1).addRegister("s_nextCounterValue", -1).addRegister("s_carry", 1).addRegister("s_counterValue", -1);
        this.myPorts.add("clock", "clock", 1, 2).add("input", LOAD_DATA_INPUT, -1, 1).add("input", "clear", 1, 3).add("input", "load", 1, 4).add("input", "upNotDown", 1, 5).add("input", "enable", 1, 6, false).add("output", COUNT_DATA_OUTPUT, -1, 0).add("output", "compareOut", 1, 7);
    }

    public SortedMap<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> result = new TreeMap<String, String>(super.getPortMap(nets, mapInfo));
        if (mapInfo instanceof netlistComponent) {
            int nrOfBits;
            netlistComponent compInfo = (netlistComponent)mapInfo;
            if (Hdl.isVhdl() && (nrOfBits = compInfo.getComponent().getAttributeSet().getValue(StdAttr.WIDTH).getWidth()) == 1) {
                String mappedInputData = result.get(LOAD_DATA_INPUT);
                String mappedOutputData = result.get(COUNT_DATA_OUTPUT);
                result.remove(LOAD_DATA_INPUT);
                result.remove(COUNT_DATA_OUTPUT);
                result.put(LineBuffer.formatHdl("{{1}}{{<}}0{{>}}", LOAD_DATA_INPUT), mappedInputData);
                result.put(LineBuffer.formatHdl("{{1}}{{<}}0{{>}}", COUNT_DATA_OUTPUT), mappedOutputData);
            }
        }
        return result;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair(INVERT_CLOCK_STRING, INVERT_CLOCK_STRING).pair("clock", "clock").pair("Tick", "tick").empty().addRemarkBlock("Functionality of the counter:\n  Load Count | mode\n  -----------+-------------------\n    0    0   | halt\n    0    1   | count up (default)\n    1    0   | load\n    1    1   | count down\n").empty();
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("compareOut   <= s_carry;\ncountValue   <= s_counterValue;\n\ns_clock      <= {{clock}} {{when}} {{invertClock}} = 0 {{else}} {{not}}({{clock}});\n\nmakeCarry : {{process}}(upNotDown, s_counterValue) {{is}}\n{{begin}}\n   {{if}} (upNotDown = '0') {{then}}\n      {{if}} (s_counterValue = std_logic_vector(to_unsigned(0,width))) {{then}}\n         s_carry <= '1';\n      {{else}}\n         s_carry <= '0';\n      {{end}} {{if}}; -- Down counting\n   {{else}}\n      {{if}} (s_counterValue = maxVal) {{then}}\n         s_carry <= '1';\n      {{else}}\n         s_carry <= '0';\n      {{end}} {{if}}; -- Up counting\n   {{end}} {{if}};\n{{end}} {{process}} makeCarry;\n\ns_realEnable <= '0' {{when}} (load = '0' {{and}} enable = '0') -- Counter disabled\n                       {{or}} (mode = 1 {{and}} s_carry = '1' {{and}} load = '0') -- Stay at value situation\n                     {{else}} {{Tick}};\n\nmakeNextValue : {{process}}(load ,upNotDown ,s_counterValue ,loadData , s_carry) {{is}}\n   {{variable}} v_downcount : std_logic;\n{{begin}}\n   v_downcount := {{not}}(upNotDown);\n   {{if}} ((load = '1') {{or}} -- load condition\n       (mode = 3 {{and}} s_carry = '1')    -- Wrap load condition\n      ) {{then}} s_nextCounterValue <= loadData;\n   {{else}}\n      {{case}} (mode) {{is}}\n         {{when}}  0    => {{if}} (s_carry = '1') {{then}}\n                          {{if}} (v_downcount = '1') {{then}}\n                             s_nextCounterValue <= maxVal;\n                          {{else}}\n                             s_nextCounterValue <= ({{others}} => '0');\n                          {{end}} {{if}};\n                       {{else}}\n                          {{if}} (v_downcount = '1') {{then}}\n                             s_nextCounterValue <= std_logic_vector(unsigned(s_counterValue) - 1);\n                          {{else}}\n                             s_nextCounterValue <= std_logic_vector(unsigned(s_counterValue) + 1);\n                          {{end}} {{if}};\n                       {{end}} {{if}};\n        {{when}} {{others}} => {{if}} (v_downcount = '1') {{then}}\n                           s_nextCounterValue <= std_logic_vector(unsigned(s_counterValue) - 1);\n                       {{else}}\n                           s_nextCounterValue <= std_logic_vector(unsigned(s_counterValue) + 1);\n                       {{end}} {{if}};\n      {{end}} {{case}};\n   {{end}} {{if}};\n{{end}} {{process}} makeNextValue;\n\nmakeFlops : {{process}}(s_clock, s_realEnable, clear, s_nextCounterValue ) {{is}}\n{{begin}}\n   {{if}} (clear = '1') {{then}} s_counterValue <= ({{others}} => '0');\n   {{elsif}} (rising_edge(s_clock)) {{then}}\n      {{if}} (s_realEnable = '1') {{then}} s_counterValue <= s_nextCounterValue;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeFlops;\n");
        } else {
            contents.add("assign compareOut = s_carry;\nassign countValue = s_counterValue;\nassign s_clock = ({{invertClock}} == 0) ? {{clock}} : ~{{clock}};\n\nalways@(*)\nbegin\nif (upNotDown)\n   s_carry = (s_counterValue == maxVal) ? 1'b1 : 1'b0;\nelse\n   s_carry = (s_counterValue == 0) ? 1'b1 : 1'b0;\nend\n\nassign s_realEnable = ((~(load)&~(enable))|\n                        ((mode==1)&s_carry&~(load))) ? 1'b0 : {{Tick}};\n\nalways @(*)\nbegin\n   if ((load)|((mode==3)&s_carry))\n      s_nextCounterValue = loadData;\n   else if ((mode==0)&s_carry&upNotDown)\n      s_nextCounterValue = 0;\n   else if ((mode==0)&s_carry)\n      s_nextCounterValue = maxVal;\n   else if (upNotDown)\n      s_nextCounterValue = s_counterValue + 1;\n   else\n      s_nextCounterValue = s_counterValue - 1;\nend\n\nalways @(posedge s_clock or posedge clear)\nbegin\n   if (clear) s_counterValue <= 0;\n   else if (s_realEnable) s_counterValue <= s_nextCounterValue;\nend\n");
        }
        return contents.empty();
    }
}

