/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.MemMenu;
import com.cburch.logisim.std.memory.MemPoker;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.StringGetter;
import java.io.File;
import java.util.WeakHashMap;

public abstract class Mem
extends InstanceFactory {
    public static final int SymbolWidth = 200;
    public static final Attribute<BitWidth> ADDR_ATTR = Attributes.forBitWidth("addrWidth", Strings.S.getter("ramAddrWidthAttr"), 2, 24);
    public static final Attribute<BitWidth> DATA_ATTR = Attributes.forBitWidth("dataWidth", Strings.S.getter("ramDataWidthAttr"));
    public static final AttributeOption SEL_HIGH = new AttributeOption("high", Strings.S.getter("stdTriggerHigh"));
    public static final AttributeOption SEL_LOW = new AttributeOption("low", Strings.S.getter("stdTriggerLow"));
    public static final Attribute<AttributeOption> ATTR_SELECTION = Attributes.forOption("Select", Strings.S.getter("ramSelAttr"), new AttributeOption[]{SEL_HIGH, SEL_LOW});
    public static final AttributeOption SINGLE = new AttributeOption("single", Strings.S.getter("memSingle"));
    public static final AttributeOption DUAL = new AttributeOption("dual", Strings.S.getter("memDual"));
    public static final AttributeOption QUAD = new AttributeOption("quad", Strings.S.getter("memQuad"));
    public static final AttributeOption OCTO = new AttributeOption("octo", Strings.S.getter("memOcto"));
    public static final Attribute<AttributeOption> LINE_ATTR = Attributes.forOption("line", Strings.S.getter("memLineSize"), new AttributeOption[]{SINGLE, DUAL, QUAD, OCTO});
    public static final Attribute<Boolean> ALLOW_MISALIGNED = Attributes.forBoolean("misaligned", Strings.S.getter("memMisaligned"));
    static final AttributeOption WRITEAFTERREAD = new AttributeOption("war", Strings.S.getter("memWar"));
    static final AttributeOption READAFTERWRITE = new AttributeOption("raw", Strings.S.getter("memRaw"));
    static final Attribute<AttributeOption> READ_ATTR = Attributes.forOption("readbehav", Strings.S.getter("memReadBehav"), new AttributeOption[]{WRITEAFTERREAD, READAFTERWRITE});
    public static final AttributeOption USEBYTEENABLES = new AttributeOption("byte", Strings.S.getter("memByte"));
    public static final AttributeOption USELINEENABLES = new AttributeOption("line", Strings.S.getter("memLine"));
    public static final Attribute<AttributeOption> ENABLES_ATTR = Attributes.forOption("enables", Strings.S.getter("memEnables"), new AttributeOption[]{USEBYTEENABLES, USELINEENABLES});
    static final Attribute<Boolean> ASYNC_READ = Attributes.forBoolean("asyncread", Strings.S.getter("memAsyncRead"));
    public static final int DELAY = 10;
    private final WeakHashMap<Instance, File> currentInstanceFiles = new WeakHashMap();

    Mem(String name, StringGetter desc, int extraPorts, HdlGeneratorFactory generator, boolean needsLabel) {
        super(name, desc, generator, needsLabel);
        this.setInstancePoker(MemPoker.class);
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(ADDR_ATTR, 2, 24, 0), new BitWidthConfigurator(DATA_ATTR)));
        this.setOffsetBounds(Bounds.create(-140, -40, 140, 80));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        Bounds bds = instance.getBounds();
        int x = bds.getX() + bds.getWidth() / 2;
        int y = bds.getY() - 2;
        boolean halign = false;
        int valign = 2;
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, x, y, 0, 2);
    }

    abstract void configurePorts(Instance var1);

    @Override
    public abstract AttributeSet createAttributeSet();

    public File getCurrentImage(Instance instance) {
        return this.currentInstanceFiles.get(instance);
    }

    abstract HexFrame getHexFrame(Project var1, Instance var2, CircuitState var3);

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        return key == MenuExtender.class ? new MemMenu(this, instance) : super.getInstanceFeature(instance, key);
    }

    protected static String getSizeLabel(int NrAddressBits) {
        int addrBits;
        String[] labels = new String[]{"", "K", "M", "G", "T", "P", "E"};
        int pass = 0;
        for (addrBits = NrAddressBits; addrBits > 9; addrBits -= 10) {
            ++pass;
        }
        int size = 1 << addrBits;
        return size + labels[pass];
    }

    abstract MemState getState(Instance var1, CircuitState var2);

    abstract MemState getState(InstanceState var1);

    @Override
    public abstract void propagate(InstanceState var1);

    public void setCurrentImage(Instance instance, File value) {
        this.currentInstanceFiles.put(instance, value);
    }

    static class MemListener
    implements HexModelListener {
        final Instance instance;

        MemListener(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void bytesChanged(HexModel source, long start, long numBytes, long[] values) {
            this.instance.fireInvalidated();
        }

        @Override
        public void metainfoChanged(HexModel source) {
        }
    }
}

