/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class RegisterHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_Id = -1;
    private static final String INVERT_CLOCK_STRING = "invertClock";
    private static final int INVERT_CLOCK_Id = -2;

    public RegisterHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STRING, -1).add(INVERT_CLOCK_STRING, -2, 4, StdAttr.TRIGGER, AbstractFlipFlopHdlGeneratorFactory.TRIGGER_MAP);
        this.myWires.addWire("s_clock", 1).addRegister("s_currentState", -1);
        this.myPorts.add("clock", HdlPorts.getClockName(1), 1, 2).add("input", "reset", 1, 3).add("input", "clockEnable", 1, 4, false).add("input", "d", -1, 1).add("output", "q", -1, 0);
    }

    public SortedMap<String, String> getPortMap(Netlist Nets, Object MapInfo2) {
        TreeMap<String, String> map = new TreeMap<String, String>(super.getPortMap(Nets, MapInfo2));
        if (MapInfo2 instanceof netlistComponent) {
            int nrOfBits;
            netlistComponent comp = (netlistComponent)MapInfo2;
            if (Hdl.isVhdl() && (nrOfBits = comp.getComponent().getAttributeSet().getValue(StdAttr.WIDTH).getWidth()) == 1) {
                String inMap = map.get("d");
                String outMap = map.get("q");
                map.remove("d");
                map.remove("q");
                map.put("d(0)", inMap);
                map.put("q(0)", outMap);
            }
        }
        return map;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair(INVERT_CLOCK_STRING, INVERT_CLOCK_STRING).pair("clock", HdlPorts.getClockName(1)).pair("Tick", HdlPorts.getTickName(1));
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("q       <= s_currentState;\ns_clock <= {{clock}} {{when}} {{invertClock}} = 0 {{else}} {{not}}({{clock}});\n\nmakeMemory : {{process}}(s_clock, reset, clockEnable, {{Tick}}, d) {{is}}\n{{begin}}\n   {{if}} (reset = '1') {{then}} s_currentState <= ({{others}} => '0');\n");
            if (Netlist.isFlipFlop(attrs)) {
                contents.add("{{elsif}} (rising_Edge(s_clock)) {{then}}\n   {{if}} (clockEnable = '1' {{and}} {{Tick}} = '1') {{then}}\n      s_currentState <= d;\n   {{end}} {{if}};\n");
            } else {
                contents.add("{{elsif}} (s_clock = '1') {{then}}\n   {{if}} (clockEnable = '1' {{and}} {{Tick}} = '1') {{then}}\n      s_currentState <= d;\n   {{end}} {{if}};\n");
            }
            contents.add("   {{end}} {{if}};\n{{end}} {{process}} makeMemory;\n");
        } else {
            contents.empty().add("assign q = s_currentState;\nassign s_clock = {{invertClock}} == 0 ? {{clock}} : ~{{clock}};\n").empty();
            if (Netlist.isFlipFlop(attrs)) {
                contents.add("always @(posedge s_clock or posedge reset)\nbegin\n   if (reset) s_currentState <= 0;\n   else if (clockEnable&{{Tick}}) s_currentState <= d;\nend\n");
            } else {
                contents.add("always @(*)\nbegin\n   if (reset) s_currentState <= 0;\n   else if (s_Clock&clockEnable&{{Tick}}) s_currentState <= d;\nend\n");
            }
        }
        return contents.empty();
    }
}

