/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.memory.ClockState;
import java.util.Arrays;

class ShiftRegisterData
extends ClockState
implements InstanceData {
    private BitWidth width;
    private Value[] vs;
    private int vsPos;

    public ShiftRegisterData(BitWidth width, int len) {
        this.width = width;
        this.vs = new Value[len];
        Arrays.fill(this.vs, AppPreferences.Memory_Startup_Unknown.get() != false ? Value.createUnknown(width) : Value.createKnown(width, 0L));
        this.vsPos = 0;
    }

    public void clear() {
        Arrays.fill(this.vs, Value.createKnown(this.width, 0L));
        this.vsPos = 0;
    }

    @Override
    public ShiftRegisterData clone() {
        ShiftRegisterData ret = (ShiftRegisterData)super.clone();
        ret.vs = (Value[])this.vs.clone();
        return ret;
    }

    public Value get(int index) {
        int i = this.vsPos + index;
        Value[] v = this.vs;
        if (i >= v.length) {
            i -= v.length;
        }
        return v[i];
    }

    public int getLength() {
        return this.vs.length;
    }

    public void push(Value v) {
        int pos = this.vsPos;
        this.vs[pos] = v;
        this.vsPos = pos >= this.vs.length - 1 ? 0 : pos + 1;
    }

    public void set(int index, Value val) {
        int i = this.vsPos + index;
        Value[] v = this.vs;
        if (i >= v.length) {
            i -= v.length;
        }
        v[i] = val;
    }

    public void setDimensions(BitWidth newWidth, int newLength) {
        Object[] v = this.vs;
        BitWidth oldWidth = this.width;
        int oldW = oldWidth.getWidth();
        int newW = newWidth.getWidth();
        if (v.length != newLength) {
            Object[] newV = new Value[newLength];
            int j = this.vsPos;
            int copy = Math.min(newLength, v.length);
            for (int i = 0; i < copy; ++i) {
                newV[i] = v[j];
                if (++j != v.length) continue;
                j = 0;
            }
            Arrays.fill(newV, copy, newLength, Value.createKnown(newWidth, 0L));
            v = newV;
            this.vsPos = 0;
            this.vs = newV;
        }
        if (oldW != newW) {
            for (int i = 0; i < v.length; ++i) {
                Value vi = v[i];
                if (vi.getWidth() == newW) continue;
                v[i] = vi.extendWidth(newW, Value.FALSE);
            }
            this.width = newWidth;
        }
    }
}

