/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.std.memory.ShiftRegister;
import com.cburch.logisim.util.LineBuffer;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ShiftRegisterHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NEGATE_CLOCK_STRING = "negateClock";
    private static final int NEGATE_CLOCK_ID = -1;
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -2;
    private static final String NR_OF_STAGES_STRING = "nrOfStages";
    private static final int NR_OF_STAGES_ID = -3;
    private static final String NR_OF_PAR_BITS_STRING = "nrOfParBits";
    private static final int NR_OF_PAR_BITS_ID = -4;

    public ShiftRegisterHdlGeneratorFactory() {
        this.myParametersList.add(NEGATE_CLOCK_STRING, -1, 4, StdAttr.EDGE_TRIGGER, AbstractFlipFlopHdlGeneratorFactory.TRIGGER_MAP).add(NR_OF_BITS_STRING, -2).add(NR_OF_PAR_BITS_STRING, -4, 3, StdAttr.WIDTH, ShiftRegister.ATTR_LENGTH).add(NR_OF_STAGES_STRING, -3, 6, ShiftRegister.ATTR_LENGTH);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        Boolean hasParallelLoad = attrs.getValue(ShiftRegister.ATTR_LOAD);
        this.myPorts.add("clock", HdlPorts.getClockName(1), 1, 2).add("input", "reset", 1, 3).add("input", "shiftEnable", 1, 1).add("input", "shiftIn", -2, 0).add("input", "d", -4, "DUMMY_MAP").add("output", "shiftOut", -2, 4).add("output", "q", -4, "DUMMY_MAP");
        if (hasParallelLoad.booleanValue()) {
            this.myPorts.add("input", "parLoad", 1, 5);
        } else {
            this.myPorts.add("input", "parLoad", 1, Hdl.zeroBit());
        }
    }

    public SortedMap<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> map = new TreeMap<String, String>(super.getPortMap(nets, mapInfo));
        if (mapInfo instanceof netlistComponent) {
            netlistComponent comp = (netlistComponent)mapInfo;
            AttributeSet attrs = comp.getComponent().getAttributeSet();
            int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
            Integer nrOfStages = attrs.getValue(ShiftRegister.ATTR_LENGTH);
            Boolean hasParallelLoad = attrs.getValue(ShiftRegister.ATTR_LOAD);
            StringBuilder vector = new StringBuilder();
            if (Hdl.isVhdl() && nrOfBits == 1) {
                String shiftMap = map.get("shiftIn");
                String outMap = map.get("shiftOut");
                map.remove("shiftIn");
                map.remove("shiftOut");
                map.put("shiftIn(0)", shiftMap);
                map.put("shiftOut(0)", outMap);
            }
            map.remove("d");
            map.remove("q");
            if (hasParallelLoad.booleanValue()) {
                if (nrOfBits == 1) {
                    if (Hdl.isVhdl()) {
                        for (int stage = 0; stage < nrOfStages; ++stage) {
                            map.putAll(Hdl.getNetMap(String.format("d(%d)", stage), true, comp, 6 + 2 * stage, nets));
                        }
                        int nrOfOutStages = attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC ? nrOfStages : nrOfStages - 1;
                        for (int stage = 0; stage < nrOfOutStages; ++stage) {
                            map.putAll(Hdl.getNetMap(String.format("q(%d)", stage), true, comp, 7 + 2 * stage, nets));
                        }
                        map.put(String.format("q(%d)", nrOfStages - 1), "OPEN");
                    } else {
                        int stage;
                        for (stage = nrOfStages - 1; stage >= 0; --stage) {
                            if (vector.length() != 0) {
                                vector.append(",");
                            }
                            vector.append(Hdl.getNetName(comp, 6 + 2 * stage, true, nets));
                        }
                        map.put("d", vector.toString());
                        vector.setLength(0);
                        vector.append("open");
                        for (stage = nrOfStages - 2; stage >= 0; --stage) {
                            if (vector.length() != 0) {
                                vector.append(",");
                            }
                            vector.append(Hdl.getNetName(comp, 7 + 2 * stage, true, nets));
                        }
                        map.put("q", vector.toString());
                    }
                } else if (Hdl.isVhdl()) {
                    for (int bit = 0; bit < nrOfBits; ++bit) {
                        for (int stage = 0; stage < nrOfStages; ++stage) {
                            int index = bit * nrOfStages + stage;
                            int id = 6 + 2 * stage;
                            map.put(String.format("d(%d)", index), Hdl.getBusEntryName(comp, id, true, bit, nets));
                            if (stage == nrOfStages - 1) continue;
                            map.put(String.format("q(%d)", index), Hdl.getBusEntryName(comp, id + 1, true, bit, nets));
                        }
                        map.put(String.format("q(%d)", (bit + 1) * nrOfStages - 1), "OPEN");
                    }
                } else {
                    int bit;
                    vector.setLength(0);
                    for (bit = nrOfBits - 1; bit >= 0; --bit) {
                        for (int stage = nrOfStages - 1; stage >= 0; --stage) {
                            if (vector.length() != 0) {
                                vector.append(",");
                            }
                            vector.append(Hdl.getBusEntryName(comp, 6 + 2 * stage, true, bit, nets));
                        }
                    }
                    map.put("d", vector.toString());
                    vector.setLength(0);
                    for (bit = nrOfBits - 1; bit >= 0; --bit) {
                        if (vector.length() != 0) {
                            vector.append(",");
                        }
                        vector.append("open");
                        for (int stage = nrOfStages - 2; stage >= 0; --stage) {
                            if (vector.length() != 0) {
                                vector.append(",");
                            }
                            vector.append(Hdl.getBusEntryName(comp, 7 + 2 * stage, true, bit, nets));
                        }
                    }
                    map.put("q", vector.toString());
                }
            } else {
                map.put("d", Hdl.getConstantVector(0L, nrOfBits * nrOfStages));
                map.put("q", Hdl.unconnected(true));
            }
        }
        return map;
    }

    @Override
    public List<String> getArchitecture(Netlist nets, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1)).pair(NR_OF_STAGES_STRING, NR_OF_STAGES_STRING).pair("invertClock", NEGATE_CLOCK_STRING).add(super.getArchitecture(nets, attrs, componentName)).empty(3);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("{{architecture}} noPlatformSpecific {{of}} singleBitShiftReg {{is}}\n\n   {{signal}} s_stateReg  : std_logic_vector( ({{nrOfStages}}-1) {{downto}} 0 );\n   {{signal}} s_stateNext : std_logic_vector( ({{nrOfStages}}-1) {{downto}} 0 );\n   {{signal}} s_clock     : std_logic;\n\n{{begin}}\n   q        <= s_stateReg;\n   shiftOut <= s_stateReg({{nrOfStages}}-1);\n   s_clock  <= {{clock}} {{when}} {{invertClock}} = 0 {{else}} {{not}}({{clock}});\n\n   s_stateNext <= d {{when}} parLoad = '1' {{else}} s_stateReg(({{nrOfStages}}-2) {{downto}} 0)&shiftIn;\n\n   makeState : {{process}}(s_clock, shiftEnable, {{tick}}, reset, s_stateNext, parLoad) {{is}}\n   {{begin}}\n      {{if}} (reset = '1') {{then}} s_stateReg <= ({{others}} => '0');\n      {{elsif}} (rising_edge(s_clock)) {{then}}\n         {{if}} (((shiftEnable = '1') {{or}} (parLoad = '1')) {{and}} ({{tick}} = '1')) {{then}}\n            s_stateReg <= s_stateNext;\n         {{end}} {{if}};\n      {{end}} {{if}};\n   {{end}} {{process}} makeState;\n{{end}} noPlatformSpecific;\n\n");
        } else {
            contents.add("module singleBitShiftReg ( reset,\n                           {{tick}},\n                           {{clock}},\n                           shiftEnable,\n                           parLoad,\n                           shiftIn,\n                           d,\n                           shiftOut,\n                           q);\n\n   parameter {{nrOfStages}} = 1;\n   parameter {{invertClock}} = 1;\n\n   input reset;\n   input {{tick}};\n   input {{clock}};\n   input shiftEnable;\n   input parLoad;\n   input shiftIn;\n   input[{{nrOfStages}}:0] d;\n   output shiftOut;\n   output[{{nrOfStages}}:0] q;\n\n   wire[{{nrOfStages}}:0] s_stateNext;\n   wire s_clock;\n   reg[{{nrOfStages}}:0] s_stateReg;\n\n   assign q        = s_stateReg;\n   assign shiftOut = s_stateReg[{{nrOfStages}}-1];\n   assign s_clock  = {{invertClock}} == 0 ? {{clock}} : ~{{clock}};\n   assign s_stateNext = (parLoad) ? d : {s_stateReg[{{nrOfStages}}-2:0],shiftIn};\n\n   always @(posedge s_clock or posedge reset)\n   begin\n      if (reset) s_stateReg <= 0;\n      else if ((shiftEnable|parLoad)&{{tick}}) s_stateReg <= s_stateNext;\n   end\n\nendmodule\n");
        }
        contents.empty();
        return contents.get();
    }

    @Override
    public LineBuffer getComponentDeclarationSection(Netlist nets, AttributeSet attrs) {
        return this.getExtraComp(false);
    }

    private LineBuffer getExtraComp(boolean isEntity) {
        return LineBuffer.getHdlBuffer().addVhdlKeywords().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1)).pair(NR_OF_STAGES_STRING, NR_OF_STAGES_STRING).pair("invertClock", NEGATE_CLOCK_STRING).add(isEntity ? "{{entity}} singleBitShiftReg {{is}}" : "{{component}} singleBitShiftReg").add("   {{generic}} ( {{invertClock}} : {{integer}};\n             {{nrOfStages}}  : {{integer}} );\n   {{port}} ( reset       : {{in}}  std_logic;\n          {{tick}}        : {{in}}  std_logic;\n          {{clock}}       : {{in}}  std_logic;\n          shiftEnable : {{in}}  std_logic;\n          parLoad     : {{in}}  std_logic;\n          shiftIn     : {{in}}  std_logic;\n          d           : {{in}}  std_logic_vector( ({{nrOfStages}}-1) {{downto}} 0 );\n          shiftOut    : {{out}} std_logic;\n          q           : {{out}} std_logic_vector( ({{nrOfStages}}-1) {{downto}} 0 ) );\n").add(isEntity ? "{{end}} {{entity}} singleBitShiftReg;" : "{{end}} {{component}};");
    }

    @Override
    public List<String> getEntity(Netlist nets, AttributeSet attrs, String componentName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        if (Hdl.isVhdl()) {
            contents.add(super.getEntity(nets, attrs, componentName)).empty().add(Hdl.getExtendedLibrary()).add(this.getExtraComp(true));
        }
        return contents.get();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", HdlPorts.getClockName(1)).pair("tick", HdlPorts.getTickName(1)).pair(NR_OF_STAGES_STRING, NR_OF_STAGES_STRING).pair("invertClock", NEGATE_CLOCK_STRING).pair(NR_OF_BITS_STRING, NR_OF_BITS_STRING);
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("genBits : {{for}} n {{in}} ({{nrOfBits}}-1) {{downto}} 0 {{generate}}\n   OneBit : singleBitShiftReg\n   {{generic}} {{map}} ( {{invertClock}} => {{invertClock}},\n                 {{nrOfStages}} => {{nrOfStages}} )\n   {{port}} {{map}} ( reset       => reset,\n              {{tick}}        => {{tick}},\n              {{clock}}       => {{clock}},\n              shiftEnable => shiftEnable,\n              parLoad     => parLoad,\n              shiftIn     => shiftIn(n),\n              d           => d( ((n+1) * {{nrOfStages}})-1 {{downto}} (n*{{nrOfStages}})),\n              shiftOut    => shiftOut(n),\n              q           => q( ((n+1) * {{nrOfStages}})-1 {{downto}} (n*{{nrOfStages}})) );\n{{end}} {{generate}} genBits;\n");
        } else {
            contents.add("genvar n;\ngenerate\n   for (n = 0 ; n < {{nrOfBits}}; n=n+1)\n   begin:Bit\n      singleBitShiftReg #(.{{invertClock}}({{invertClock}}),\n                          .{{nrOfStages}}({{nrOfStages}}))\n         OneBit (.reset(reset),\n                 .{{tick}}({{tick}}),\n                 .{{clock}}({{clock}}),\n                 .shiftEnable(shiftEnable),\n                 .parLoad(parLoad),\n                 .shiftIn(shiftIn[n]),\n                 .d(d[((n+1)*{{nrOfStages}})-1:(n*{{nrOfStages}})]),\n                 .shiftOut(shiftOut[n]),\n                 .q(q[((n+1)*{{nrOfStages}})-1:(n*{{nrOfStages}})]) );\n   end\nendgenerate\n");
        }
        return contents.empty();
    }
}

