/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.util.LineBuffer;

public class DecoderHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public DecoderHdlGeneratorFactory() {
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        int nrOfselectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int selectInputIndex = 1 << nrOfselectBits;
        for (int outp = 0; outp < selectInputIndex; ++outp) {
            this.myPorts.add("output", String.format("decoderOut_%d", outp), 1, outp);
        }
        this.myPorts.add("input", "sel", nrOfselectBits, selectInputIndex);
        if (attrs.getValue(PlexersLibrary.ATTR_ENABLE).booleanValue()) {
            this.myPorts.add("input", "enable", 1, selectInputIndex + 1, false);
        } else {
            this.myPorts.add("input", "enable", 1, Hdl.oneBit());
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetList, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        int nrOfselectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int numOutputs = 1 << nrOfselectBits;
        String space = " ";
        for (int i = 0; i < numOutputs; ++i) {
            if (i == 10) {
                space = "";
            }
            contents.pair("bin", Hdl.getConstantVector(i, nrOfselectBits)).pair("i", i);
            if (Hdl.isVhdl()) {
                contents.empty().addVhdlKeywords().add("decoderOut_{{i}}{{1}}<= '1' {{when}} sel = {{bin}} {{and}}\n{{1}}                        enable = '1' {{else}} '0';\n", space);
                continue;
            }
            contents.add("assign decoderOut_{{i}}{{1}} = (enable&(sel == {{bin}})) ? 1'b1 : 1'b0;", space);
        }
        return contents;
    }
}

