/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.PlexerIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.DemultiplexerHdlGeneratorFactory;
import com.cburch.logisim.std.plexers.Multiplexer;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Demultiplexer
extends InstanceFactory {
    public static final String _ID = "Demultiplexer";

    public Demultiplexer() {
        super(_ID, Strings.S.getter("demultiplexerComponent"), new DemultiplexerHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.SELECT_LOC, PlexersLibrary.ATTR_SELECT, StdAttr.WIDTH, PlexersLibrary.ATTR_TRISTATE, PlexersLibrary.ATTR_DISABLED, PlexersLibrary.ATTR_ENABLE}, new Object[]{Direction.EAST, StdAttr.SELECT_BOTTOM_LEFT, PlexersLibrary.DEFAULT_SELECT, BitWidth.ONE, PlexersLibrary.DEFAULT_TRISTATE, PlexersLibrary.DISABLED_ZERO, PlexersLibrary.DEFAULT_ENABLE});
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(PlexersLibrary.ATTR_SELECT, 1, 5, 0), new BitWidthConfigurator(StdAttr.WIDTH)));
        this.setFacingAttribute(StdAttr.FACING);
        this.setIcon(new PlexerIcon(true, false));
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        if (attr == PlexersLibrary.ATTR_ENABLE) {
            return ver.compareTo(new LogisimVersion(3, 6, 1)) <= 0;
        }
        return super.getDefaultAttributeValue(attr, ver);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING).reverse();
        return PlexersLibrary.contains(loc, this.getOffsetBounds(attrs), facing);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()));
        if (attrs.getValue(StdAttr.WIDTH).getWidth() > 1) {
            completeName.append("_bus");
        }
        completeName.append("_").append(1 << attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth());
        return completeName.toString();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        BitWidth select = attrs.getValue(PlexersLibrary.ATTR_SELECT);
        int outputs = 1 << select.getWidth();
        Bounds bds = outputs == 2 ? Bounds.create(0, -25, 30, 50) : Bounds.create(0, -(outputs / 2) * 10 - 10, 40, outputs * 10 + 20);
        return bds.rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.getValue(PlexersLibrary.ATTR_TRISTATE) != false || attrs.getValue(PlexersLibrary.ATTR_DISABLED) == PlexersLibrary.DISABLED_FLOATING;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == StdAttr.SELECT_LOC || attr == PlexersLibrary.ATTR_SELECT) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == StdAttr.WIDTH || attr == PlexersLibrary.ATTR_ENABLE) {
            this.updatePorts(instance);
        } else if (attr == PlexersLibrary.ATTR_TRISTATE || attr == PlexersLibrary.ATTR_DISABLED) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Bounds bds = painter.getBounds();
        if (select.getWidth() == 1) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                PlexersLibrary.drawTrapezoid(painter.getGraphics(), Bounds.create(bds.getX(), bds.getY() + 5, bds.getWidth(), bds.getHeight() - 10), facing.reverse(), 10);
            } else {
                PlexersLibrary.drawTrapezoid(painter.getGraphics(), Bounds.create(bds.getX() + 5, bds.getY(), bds.getWidth() - 10, bds.getHeight()), facing.reverse(), 10);
            }
        } else {
            PlexersLibrary.drawTrapezoid(painter.getGraphics(), bds, facing.reverse(), 20);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int halign;
        int y0;
        int x0;
        int dy;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        BitWidth select = painter.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = painter.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int outputs = 1 << select.getWidth();
        GraphicsUtil.switchToWidth(g, 3);
        boolean vertical = facing == Direction.NORTH || facing == Direction.SOUTH;
        AttributeOption selectLoc = painter.getAttributeValue(StdAttr.SELECT_LOC);
        int selMult = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 1 : -1;
        int dx = vertical ? selMult : 0;
        int n = dy = vertical ? 0 : -selMult;
        if (outputs == 2) {
            Location sel = painter.getInstance().getPortLocation(outputs);
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(outputs).getColor());
            }
            g.drawLine(sel.getX(), sel.getY(), sel.getX() + 2 * dx, sel.getY() + 2 * dy);
        }
        if (enable.booleanValue()) {
            Location en = painter.getInstance().getPortLocation(outputs + 1);
            if (painter.getShowState()) {
                g.setColor(painter.getPortValue(outputs + 1).getColor());
            }
            int len = outputs == 2 ? 6 : 4;
            g.drawLine(en.getX(), en.getY(), en.getX() + len * dx, en.getY() + len * dy);
        }
        GraphicsUtil.switchToWidth(g, 1);
        Multiplexer.drawSelectCircle(g, bds, painter.getInstance().getPortLocation(outputs));
        if (facing == Direction.WEST) {
            x0 = 3;
            y0 = 15 + (outputs == 2 ? 5 : 0);
            halign = -1;
        } else if (facing == Direction.NORTH) {
            x0 = 10 + (outputs == 2 ? 5 : 0);
            y0 = 15;
            halign = 0;
        } else if (facing == Direction.SOUTH) {
            x0 = 10 + (outputs == 2 ? 5 : 0);
            y0 = bds.getHeight() - 3;
            halign = 0;
        } else {
            x0 = bds.getWidth() - 3;
            y0 = 15 + (outputs == 2 ? 5 : 0);
            halign = 1;
        }
        g.setColor(Color.GRAY);
        GraphicsUtil.drawText(g, "0", bds.getX() + x0, bds.getY() + y0, halign, 1);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        if (outputs == 2) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                PlexersLibrary.drawTrapezoid(g, Bounds.create(bds.getX(), bds.getY() + 5, bds.getWidth(), bds.getHeight() - 10), facing.reverse(), 10);
            } else {
                PlexersLibrary.drawTrapezoid(g, Bounds.create(bds.getX() + 5, bds.getY(), bds.getWidth() - 10, bds.getHeight()), facing.reverse(), 10);
            }
        } else {
            PlexersLibrary.drawTrapezoid(g, bds, facing.reverse(), 20);
        }
        GraphicsUtil.drawCenteredText(g, "DMX", bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth data = state.getAttributeValue(StdAttr.WIDTH);
        BitWidth select = state.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean threeState = state.getAttributeValue(PlexersLibrary.ATTR_TRISTATE);
        boolean enable = state.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int outputs = 1 << select.getWidth();
        Value en = enable ? state.getPortValue(outputs + 1) : Value.TRUE;
        Value others = threeState != false ? Value.createUnknown(data) : Value.createKnown(data, 0L);
        int outIndex = -1;
        Value out = null;
        if (en == Value.FALSE) {
            AttributeOption opt = state.getAttributeValue(PlexersLibrary.ATTR_DISABLED);
            Value base = opt == PlexersLibrary.DISABLED_ZERO ? Value.FALSE : Value.UNKNOWN;
            others = Value.repeat(base, data.getWidth());
        } else if (en == Value.ERROR && state.isPortConnected(outputs + 1)) {
            others = Value.createError(data);
        } else {
            Value sel = state.getPortValue(outputs);
            if (sel.isFullyDefined()) {
                outIndex = (int)sel.toLongValue();
                out = state.getPortValue(outputs + (enable ? 2 : 1));
            } else {
                others = sel.isErrorValue() ? Value.createError(data) : Value.createUnknown(data);
            }
        }
        for (int i = 0; i < outputs; ++i) {
            state.setPort(i, i == outIndex ? out : others, 3);
        }
    }

    private void updatePorts(Instance instance) {
        Location sel;
        int selMult;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        BitWidth data = instance.getAttributeValue(StdAttr.WIDTH);
        BitWidth select = instance.getAttributeValue(PlexersLibrary.ATTR_SELECT);
        Boolean enable = instance.getAttributeValue(PlexersLibrary.ATTR_ENABLE);
        int outputs = 1 << select.getWidth();
        Port[] ps = new Port[outputs + (enable != false ? 3 : 2)];
        int n = selMult = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? 1 : -1;
        if (outputs == 2) {
            Location end1;
            Location end0;
            if (facing == Direction.WEST) {
                end0 = Location.create(-30, -10, true);
                end1 = Location.create(-30, 10, true);
                sel = Location.create(-20, selMult * 20, true);
            } else if (facing == Direction.NORTH) {
                end0 = Location.create(-10, -30, true);
                end1 = Location.create(10, -30, true);
                sel = Location.create(selMult * -20, -20, true);
            } else if (facing == Direction.SOUTH) {
                end0 = Location.create(-10, 30, true);
                end1 = Location.create(10, 30, true);
                sel = Location.create(selMult * -20, 20, true);
            } else {
                end0 = Location.create(30, -10, true);
                end1 = Location.create(30, 10, true);
                sel = Location.create(20, selMult * 20, true);
            }
            ps[0] = new Port(end0.getX(), end0.getY(), "output", data.getWidth());
            ps[1] = new Port(end1.getX(), end1.getY(), "output", data.getWidth());
        } else {
            int dx = -(outputs / 2) * 10;
            int ddx = 10;
            int dy = dx;
            int ddy = 10;
            if (facing == Direction.WEST) {
                dx = -40;
                ddx = 0;
                sel = Location.create(-20, selMult * (dy + 10 * outputs), true);
            } else if (facing == Direction.NORTH) {
                dy = -40;
                ddy = 0;
                sel = Location.create(selMult * dx, -20, true);
            } else if (facing == Direction.SOUTH) {
                dy = 40;
                ddy = 0;
                sel = Location.create(selMult * dx, 20, true);
            } else {
                dx = 40;
                ddx = 0;
                sel = Location.create(20, selMult * (dy + 10 * outputs), true);
            }
            for (int i = 0; i < outputs; ++i) {
                ps[i] = new Port(dx, dy, "output", data.getWidth());
                dx += ddx;
                dy += ddy;
            }
        }
        Location en = sel.translate(facing, -10);
        ps[outputs] = new Port(sel.getX(), sel.getY(), "input", select.getWidth());
        if (enable.booleanValue()) {
            ps[outputs + 1] = new Port(en.getX(), en.getY(), "input", BitWidth.ONE);
        }
        ps[ps.length - 1] = new Port(0, 0, "input", data.getWidth());
        for (int i = 0; i < outputs; ++i) {
            ps[i].setToolTip(Strings.S.getter("demultiplexerOutTip", "" + i));
        }
        ps[outputs].setToolTip(Strings.S.getter("demultiplexerSelectTip"));
        if (enable.booleanValue()) {
            ps[outputs + 1].setToolTip(Strings.S.getter("demultiplexerEnableTip"));
        }
        ps[ps.length - 1].setToolTip(Strings.S.getter("demultiplexerInTip"));
        instance.setPorts(ps);
    }
}

