/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.util.LineBuffer;

public class MultiplexerHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;

    public MultiplexerHdlGeneratorFactory() {
        this.myParametersList.addBusOnly(NR_OF_BITS_STRING, -1);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        int nrOfSelectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int selectInputIndex = 1 << nrOfSelectBits;
        Boolean hasenable = attrs.getValue(PlexersLibrary.ATTR_ENABLE);
        for (int inp = 0; inp < selectInputIndex; ++inp) {
            this.myPorts.add("input", String.format("muxIn_%d", inp), -1, inp, StdAttr.WIDTH);
        }
        this.myPorts.add("input", "sel", nrOfSelectBits, selectInputIndex).add("output", "muxOut", -1, hasenable != false ? selectInputIndex + 2 : selectInputIndex + 1, StdAttr.WIDTH);
        if (hasenable.booleanValue()) {
            this.myPorts.add("input", "enable", 1, selectInputIndex + 1);
        } else {
            this.myPorts.add("input", "enable", 1, Hdl.oneBit());
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetList, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        int nrOfSelectBits = attrs.getValue(PlexersLibrary.ATTR_SELECT).getWidth();
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        if (Hdl.isVhdl()) {
            int i;
            contents.empty().addVhdlKeywords().add("makeMux : {{process}}(enable,");
            for (i = 0; i < 1 << nrOfSelectBits; ++i) {
                contents.add("                  muxIn_{{1}},", i);
            }
            contents.add("                  sel) {{is}}\n{{begin}}\n   {{if}} (enable = '0') {{then}}\n").add(attrs.getValue(StdAttr.WIDTH).getWidth() > 1 ? "{{2u}}muxOut <= ({{others}} => '0');" : "{{2u}}muxOut <= '0';").add("                     {{else}}\n      {{case}} (sel) IS\n");
            for (i = 0; i < (1 << nrOfSelectBits) - 1; ++i) {
                contents.add("         {{when}} {{1}} => muxOut <= muxIn_{{2}};", Hdl.getConstantVector(i, nrOfSelectBits), i);
            }
            contents.add("         {{when}} {{others}}  => muxOut <= muxIn_{{1}};", (1 << nrOfSelectBits) - 1).add("      {{end}} {{case}};\n   {{end}} {{if}};\n{{end}} {{process}} makeMux;\n");
        } else {
            if (nrOfBits == 1) {
                contents.add("reg s_selected_vector;");
            } else {
                contents.add("reg [{{1}}:0] s_selected_vector;", NR_OF_BITS_STRING);
            }
            contents.add("assign muxOut = s_selected_vector;\n\nalways @(*)\nbegin\n   if (~enable) s_selected_vector <= 0;\n   else case (sel)\n");
            for (int i = 0; i < (1 << nrOfSelectBits) - 1; ++i) {
                contents.add("      {{1}}:", Hdl.getConstantVector(i, nrOfSelectBits)).add("         s_selected_vector <= muxIn_{{1}};", i);
            }
            contents.add("     default:").add("        s_selected_vector <= muxIn_{{1}};", (1 << nrOfSelectBits) - 1).add("   endcase").add("end");
        }
        return contents.empty();
    }
}

