/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.ttl.ClockState;
import java.util.Arrays;

public class ShiftRegisterData
extends ClockState
implements InstanceData {
    private BitWidth width;
    private Value[] vs;
    private int vsPos;

    public ShiftRegisterData(BitWidth width, int len) {
        Value initialValue = AppPreferences.Memory_Startup_Unknown.get() != false ? Value.createUnknown(width) : Value.createKnown(width, 0L);
        this.width = width;
        this.vs = new Value[len];
        Arrays.fill(this.vs, initialValue);
        this.vsPos = 0;
    }

    public void clear() {
        Arrays.fill(this.vs, Value.createKnown(this.width, 0L));
        this.vsPos = 0;
    }

    @Override
    public ShiftRegisterData clone() {
        ShiftRegisterData ret = (ShiftRegisterData)super.clone();
        ret.vs = (Value[])this.vs.clone();
        return ret;
    }

    private int toInternalIndex(int index) {
        return (this.vsPos + index) % this.vs.length;
    }

    public Value get(int index) {
        return this.vs[this.toInternalIndex(index)];
    }

    public int getLength() {
        return this.vs.length;
    }

    public void pushDown(Value v) {
        this.vs[this.vsPos] = v;
        this.vsPos = this.toInternalIndex(1);
    }

    public void pushUp(Value v) {
        this.vsPos = this.toInternalIndex(this.vs.length - 1);
        this.vs[this.vsPos] = v;
    }

    public void set(int index, Value val) {
        this.vs[this.toInternalIndex((int)index)] = val;
    }

    public void setDimensions(BitWidth newWidth, int newLength) {
        Object[] v = this.vs;
        BitWidth oldWidth = this.width;
        int oldW = oldWidth.getWidth();
        int newW = newWidth.getWidth();
        if (v.length != newLength) {
            Object[] newV = new Value[newLength];
            int j = this.vsPos;
            int copy = Math.min(newLength, v.length);
            for (int i = 0; i < copy; ++i) {
                newV[i] = v[j];
                if (++j != v.length) continue;
                j = 0;
            }
            Arrays.fill(newV, copy, newLength, Value.createKnown(newWidth, 0L));
            v = newV;
            this.vsPos = 0;
            this.vs = newV;
        }
        if (oldW != newW) {
            for (int i = 0; i < v.length; ++i) {
                Value vi = v[i];
                if (vi.getWidth() == newW) continue;
                v[i] = vi.extendWidth(newW, Value.FALSE);
            }
            this.width = newWidth;
        }
    }
}

