/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.ShiftRegisterData;

public class Ttl74299
extends AbstractTtlGate {
    public static final String _ID = "74299";
    public static final int DELAY = 1;
    public static final byte S0 = 1;
    public static final byte S1 = 19;
    public static final byte SR = 11;
    public static final byte SL = 18;
    public static final byte nOE1 = 2;
    public static final byte nOE2 = 3;
    public static final byte CLK = 12;
    public static final byte nCLR = 9;
    public static final byte QA = 8;
    public static final byte QH = 17;
    public static final byte IOA = 7;
    public static final byte IOB = 13;
    public static final byte IOC = 6;
    public static final byte IOD = 14;
    public static final byte IOE = 5;
    public static final byte IOF = 15;
    public static final byte IOG = 4;
    public static final byte IOH = 16;
    public static final byte GND = 10;
    public static final byte VCC = 20;
    private static final byte[] DATA = new byte[]{16, 4, 15, 5, 14, 6, 13, 7};
    private InstanceState _state;

    public Ttl74299() {
        super(_ID, (byte)20, new byte[]{8, 17, 7, 13, 6, 14, 5, 15, 4, 16}, new String[]{"S0", "nOE1", "nOE2", "IOG", "IOE", "IOC", "IOA", "QA", "nCLR", "SR", "CLK", "IOB", "IOD", "IOF", "IOH", "QH", "SL", "S1"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, this.portNames);
    }

    private byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 10 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private Value getPort(byte dsPinNr) {
        return this._state.getPortValue(this.pinNrToPortNr(dsPinNr));
    }

    private void setPort(byte dsPinNr, Value v) {
        this._state.setPort(this.pinNrToPortNr(dsPinNr), v, 1);
    }

    private ShiftRegisterData getData() {
        ShiftRegisterData data = (ShiftRegisterData)this._state.getData();
        if (data == null) {
            data = new ShiftRegisterData(BitWidth.ONE, 8);
            this._state.setData(data);
        }
        return data;
    }

    private boolean isTriggered() {
        return this.getData().updateClock(this.getPort((byte)12), StdAttr.TRIG_RISING);
    }

    private Mode getMode() {
        int mode = (this.getPort((byte)19) == Value.TRUE ? 2 : 0) + (this.getPort((byte)1) == Value.TRUE ? 1 : 0);
        return Mode.values()[mode];
    }

    private boolean isOutputEnabled() {
        return this.getPort((byte)2) == Value.FALSE && this.getPort((byte)3) == Value.FALSE && (this.getPort((byte)1) == Value.FALSE || this.getPort((byte)19) == Value.FALSE);
    }

    private void propagateRegister() {
        if (this.getPort((byte)9) == Value.FALSE) {
            this.getData().clear();
        } else if (this.isTriggered()) {
            switch (this.getMode().ordinal()) {
                case 3: {
                    for (int i = 0; i < 8; ++i) {
                        this.getData().set(i, this.getPort(DATA[i]));
                    }
                    break;
                }
                case 2: {
                    this.getData().pushUp(this.getPort((byte)18));
                    break;
                }
                case 1: {
                    this.getData().pushDown(this.getPort((byte)11));
                    break;
                }
            }
        }
    }

    private void propagateOutputs() {
        this.setPort((byte)8, this.getData().get(7));
        this.setPort((byte)17, this.getData().get(0));
        for (int i = 0; i < 8; ++i) {
            this.setPort(DATA[i], this.isOutputEnabled() ? this.getData().get(i) : Value.UNKNOWN);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this._state = state;
        this.propagateRegister();
        this.propagateOutputs();
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{this.pinNrToPortNr((byte)12)};
    }

    static enum Mode {
        HOLD,
        SHIFT_RIGHT,
        SHIFT_LEFT,
        LOAD;

    }
}

