/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.contracts.BaseDocumentListenerContract;
import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseWindowFocusListenerContract;
import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorBooleanConvert;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.wiring.PinAttributes;
import com.cburch.logisim.std.wiring.Probe;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.LocaleListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.font.TextLayout;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Pin
extends InstanceFactory {
    public static final String _ID = "Pin";
    public static final AttributeOption INPUT = new AttributeOption("input", Strings.S.getter("pinInputOption"));
    public static final AttributeOption OUTPUT = new AttributeOption("output", Strings.S.getter("pinOutputOption"));
    public static final Attribute<AttributeOption> ATTR_TYPE = Attributes.forOption("type", Strings.S.getter("pinTypeAttr"), new AttributeOption[]{INPUT, OUTPUT});
    public static final AttributeOption SIMPLE = new AttributeOption("simple", Strings.S.getter("pinSimpleOption"));
    public static final AttributeOption TRISTATE = new AttributeOption("tristate", Strings.S.getter("pinTristateOption"));
    public static final AttributeOption PULL_DOWN = new AttributeOption("pulldown", Strings.S.getter("pinPullDownOption"));
    public static final AttributeOption PULL_UP = new AttributeOption("pullup", Strings.S.getter("pinPullUpOption"));
    public static final Attribute<AttributeOption> ATTR_BEHAVIOR = Attributes.forOption("behavior", Strings.S.getter("pinBehaviorAttr"), new AttributeOption[]{SIMPLE, TRISTATE, PULL_DOWN, PULL_UP});
    public static final Attribute<Long> ATTR_INITIAL = Attributes.forHexLong("initial", Strings.S.getter("pinResetValue"));
    public static final Pin FACTORY = new Pin();
    private static final Font ICON_WIDTH_FONT = new Font("SansSerif", 1, 9);
    public static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final Color ICON_WIDTH_COLOR = Value.widthErrorColor.darker();
    public static final int DIGIT_WIDTH = 8;

    private static PinState getState(InstanceState state) {
        PinAttributes attrs = (PinAttributes)state.getAttributeSet();
        BitWidth width = attrs.width;
        PinState ret = (PinState)state.getData();
        if (ret == null) {
            Long initialValue = attrs.getValue(ATTR_INITIAL);
            Value newValue = attrs.behavior == TRISTATE ? Value.createUnknown(width) : Value.createKnown(width.getWidth(), (long)initialValue);
            ret = new PinState();
            ret.foundValue = ret.intendedValue = newValue;
            state.setData(ret);
        }
        if (ret.intendedValue.getWidth() != width.getWidth()) {
            ret.intendedValue = ret.intendedValue.extendWidth(width.getWidth(), attrs.defaultBitValue());
        }
        if (ret.foundValue.getWidth() != width.getWidth()) {
            ret.foundValue = ret.foundValue.extendWidth(width.getWidth(), Value.UNKNOWN);
        }
        return ret;
    }

    public Pin() {
        super(_ID, Strings.S.getter("pinComponent"));
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(StdAttr.WIDTH), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        this.setInstanceLogger(PinLogger.class);
        this.setInstancePoker(PinPoker.class);
    }

    private static Direction pinLabelLoc(Direction PinDir) {
        if (PinDir == Direction.EAST) {
            return Direction.WEST;
        }
        if (PinDir == Direction.WEST) {
            return Direction.EAST;
        }
        if (PinDir == Direction.NORTH) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
        instance.addAttributeListener();
        ((PrefMonitorBooleanConvert)AppPreferences.NEW_INPUT_OUTPUT_SHAPES).addConvertListener(attrs);
        this.configurePorts(instance);
        instance.computeLabelTextField(8, Pin.pinLabelLoc(attrs.getValue(StdAttr.FACING)));
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        return attr.equals(ProbeAttributes.PROBEAPPEARANCE) ? ProbeAttributes.getDefaultProbeAppearance() : super.getDefaultAttributeValue(attr, ver);
    }

    private void configurePorts(Instance instance) {
        PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
        String endType = attrs.isOutput() ? "input" : "output";
        Port port = new Port(0, 0, endType, StdAttr.WIDTH);
        if (attrs.isOutput()) {
            port.setToolTip(Strings.S.getter("pinOutputToolTip"));
        } else {
            port.setToolTip(Strings.S.getter("pinInputToolTip"));
        }
        instance.setPorts(new Port[]{port});
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new PinAttributes();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        BitWidth width = attrs.getValue(StdAttr.WIDTH);
        boolean NewLayout = attrs.getValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW;
        return Probe.getOffsetBounds(facing, width, attrs.getValue(RadixOption.ATTRIBUTE), NewLayout, true);
    }

    public Value getValue(InstanceState state) {
        return Pin.getState((InstanceState)state).intendedValue;
    }

    public BitWidth getWidth(Instance instance) {
        PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
        return attrs.width;
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return false;
    }

    @Override
    public boolean isHDLSupportedComponent(AttributeSet attrs) {
        return true;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_TYPE) {
            this.configurePorts(instance);
        } else if (attr == StdAttr.WIDTH || attr == StdAttr.FACING || attr == RadixOption.ATTRIBUTE || attr == ProbeAttributes.PROBEAPPEARANCE) {
            instance.recomputeBounds();
            PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
            instance.computeLabelTextField(8, Pin.pinLabelLoc(attrs.facing));
        } else if (attr == ATTR_BEHAVIOR) {
            instance.fireInvalidated();
        }
    }

    public boolean isInputPin(Instance instance) {
        PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
        return attrs.type == INPUT;
    }

    public boolean isClockPin(Instance instance) {
        PinAttributes attrs = (PinAttributes)instance.getAttributeSet();
        return attrs.isClock();
    }

    private void drawNewStyleValue(InstancePainter painter, int width, int height, boolean isOutput, boolean isGhost) {
        if (isGhost) {
            return;
        }
        Value value = Pin.getState((InstanceState)painter).intendedValue;
        Graphics g = painter.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(DEFAULT_FONT);
        RadixOption radix = painter.getAttributeValue(RadixOption.ATTRIBUTE);
        Direction dir = painter.getAttributeSet().getValue(StdAttr.FACING);
        int westTranslate = isOutput ? width : width + 10;
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        if (dir == Direction.WEST) {
            g2.rotate(-Math.PI);
            g2.translate(westTranslate, 0);
        }
        if (!painter.getShowState()) {
            g.setColor(baseColor);
            GraphicsUtil.drawCenteredText(g, "x" + ((PinAttributes)painter.getAttributeSet()).width.getWidth(), -15 - (width - 15) / 2, 0);
        } else {
            int labelYPos = height / 2 - 2;
            int LabelValueXOffset = isOutput ? -15 : -20;
            g.setColor(Color.BLUE);
            g2.scale(0.7, 0.7);
            g2.drawString(radix.getIndexChar(), (int)((double)LabelValueXOffset / 0.7), (int)((double)labelYPos / 0.7));
            g2.scale(1.4285714285714286, 1.4285714285714286);
            g.setColor(baseColor);
            if (radix == null || radix == RadixOption.RADIX_2) {
                int x0;
                int wid = value.getWidth();
                if (wid == 0) {
                    GraphicsUtil.switchToWidth(g, 2);
                    int x = -15 - (width - 15) / 2;
                    g.drawLine(x - 4, 0, x + 4, 0);
                    if (dir == Direction.WEST) {
                        g2.translate(-westTranslate, 0);
                        g2.rotate(Math.PI);
                    }
                    return;
                }
                int cx = x0 = isOutput ? -20 : -25;
                int cy = height / 2 - 12;
                int cur = 0;
                for (int k = 0; k < wid; ++k) {
                    if (radix == RadixOption.RADIX_2 && !isOutput) {
                        g.setColor(value.get(k).getColor());
                        g.fillOval(cx - 4, cy - 5, 9, 14);
                        g.setColor(Color.WHITE);
                    }
                    GraphicsUtil.drawCenteredText(g, value.get(k).toDisplayString(), cx, cy);
                    if (radix == RadixOption.RADIX_2 && !isOutput) {
                        g.setColor(baseColor);
                    }
                    if (++cur == 8) {
                        cur = 0;
                        cx = x0;
                        cy -= 20;
                        continue;
                    }
                    cx -= 10;
                }
            } else {
                String text = radix.toString(value);
                int cx = isOutput ? -15 : -20;
                for (int k = text.length() - 1; k >= 0; --k) {
                    GraphicsUtil.drawText(g, text.substring(k, k + 1), cx, -2, 1, 0);
                    cx -= 8;
                }
            }
        }
        if (dir == Direction.WEST) {
            g2.translate(-westTranslate, 0);
            g2.rotate(Math.PI);
        }
    }

    private void drawInputShape(InstancePainter painter, int x, int y, int width, int height, Color LineColor, boolean isGhost) {
        PinAttributes attrs = (PinAttributes)painter.getAttributeSet();
        boolean NewShape = attrs.getValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW;
        boolean isBus = attrs.getValue(StdAttr.WIDTH).getWidth() > 1;
        Direction dir = attrs.getValue(StdAttr.FACING);
        Graphics g = painter.getGraphics();
        if (!NewShape) {
            g.drawRect(x + 1, y + 1, width - 1, height - 1);
            if (!isGhost) {
                if (!painter.getShowState()) {
                    g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
                    GraphicsUtil.drawCenteredText(g, "x" + attrs.width.getWidth(), x + width / 2, y + height / 2);
                } else {
                    Probe.paintValue(painter, Pin.getState((InstanceState)painter).intendedValue, !isBus);
                }
            }
        } else {
            Graphics2D g2 = (Graphics2D)g;
            int xpos = x + width;
            int ypos = y + height / 2;
            int rwidth = width;
            int rheight = height;
            double rotation = 0.0;
            if (dir == Direction.NORTH) {
                rotation = -1.5707963267948966;
                xpos = x + width / 2;
                ypos = y;
                rwidth = height;
                rheight = width;
            } else if (dir == Direction.SOUTH) {
                rotation = 1.5707963267948966;
                xpos = x + width / 2;
                ypos = y + height;
                rwidth = height;
                rheight = width;
            } else if (dir == Direction.WEST) {
                rotation = Math.PI;
                xpos = x;
                ypos = y + height / 2;
            }
            g2.translate(xpos, ypos);
            g2.rotate(rotation);
            Color col = g.getColor();
            if (isBus) {
                g.setColor(Value.multiColor);
                GraphicsUtil.switchToWidth(g, 4);
                g.drawLine(-3, 0, 0, 0);
                GraphicsUtil.switchToWidth(g, 2);
            } else {
                if (painter.getShowState()) {
                    g.setColor(LineColor);
                }
                GraphicsUtil.switchToWidth(g, 3);
                g.drawLine(-5, 0, 0, 0);
                GraphicsUtil.switchToWidth(g, 2);
            }
            g.setColor(col);
            int[] xPoints = new int[]{-rwidth, -15, -5, -15, -rwidth};
            int yBottom = rheight / 2;
            int yTop = -yBottom;
            int[] yPoints = new int[]{yTop, yTop, 0, yBottom, yBottom};
            g.drawPolygon(xPoints, yPoints, 5);
            this.drawNewStyleValue(painter, rwidth, rheight, false, isGhost);
            g2.rotate(-rotation);
            g2.translate(-xpos, -ypos);
        }
    }

    private void drawOutputShape(InstancePainter painter, int x, int y, int width, int height, Color LineColor, boolean isGhost) {
        PinAttributes attrs = (PinAttributes)painter.getAttributeSet();
        boolean NewShape = attrs.getValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW;
        boolean isBus = attrs.getValue(StdAttr.WIDTH).getWidth() > 1;
        Direction dir = attrs.getValue(StdAttr.FACING);
        Graphics g = painter.getGraphics();
        if (NewShape) {
            Graphics2D g2 = (Graphics2D)g;
            int xpos = x + width;
            int ypos = y + height / 2;
            int rwidth = width;
            int rheight = height;
            double rotation = 0.0;
            if (dir == Direction.NORTH) {
                rotation = -1.5707963267948966;
                xpos = x + width / 2;
                ypos = y;
                rwidth = height;
                rheight = width;
            } else if (dir == Direction.SOUTH) {
                rotation = 1.5707963267948966;
                xpos = x + width / 2;
                ypos = y + height;
                rwidth = height;
                rheight = width;
            } else if (dir == Direction.WEST) {
                rotation = Math.PI;
                xpos = x;
                ypos = y + height / 2;
            }
            g2.translate(xpos, ypos);
            g2.rotate(rotation);
            Color col = g.getColor();
            if (isBus) {
                g.setColor(Value.multiColor);
                GraphicsUtil.switchToWidth(g, 4);
                g.drawLine(-3, 0, -2, 0);
                GraphicsUtil.switchToWidth(g, 2);
            } else {
                if (painter.getShowState()) {
                    g.setColor(LineColor);
                }
                GraphicsUtil.switchToWidth(g, 3);
                g.drawLine(-3, 0, 0, 0);
                GraphicsUtil.switchToWidth(g, 2);
            }
            g.setColor(col);
            int[] xPoints = new int[]{-5, 10 - rwidth, -rwidth, 10 - rwidth, -5};
            int yTop = rheight / 2;
            int yBottom = -yTop;
            int[] yPoints = new int[]{yTop, yTop, 0, yBottom, yBottom};
            g.drawPolygon(xPoints, yPoints, 5);
            this.drawNewStyleValue(painter, rwidth, rheight, true, isGhost);
            g2.rotate(-rotation);
            g2.translate(-xpos, -ypos);
        } else {
            if (!isBus) {
                g.drawOval(x + 1, y + 1, width - 1, height - 1);
            } else {
                g.drawRoundRect(x + 1, y + 1, width - 1, height - 1, 6, 6);
            }
            if (!isGhost) {
                if (!painter.getShowState()) {
                    g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
                    GraphicsUtil.drawCenteredText(g, "x" + attrs.width.getWidth(), x + width / 2, y + height / 2);
                } else {
                    Probe.paintValue(painter, Pin.getState((InstanceState)painter).intendedValue, !isBus);
                }
            }
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        PinAttributes attrs = (PinAttributes)painter.getAttributeSet();
        Location loc = painter.getLocation();
        Bounds bds = painter.getOffsetBounds();
        int x = loc.getX();
        int y = loc.getY();
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        if (attrs.isOutput()) {
            this.drawOutputShape(painter, x + bds.getX(), y + bds.getY(), bds.getWidth(), bds.getHeight(), Color.GRAY, true);
        } else {
            this.drawInputShape(painter, x + bds.getX(), y + bds.getY(), bds.getWidth(), bds.getHeight(), Color.GRAY, true);
        }
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        PinAttributes attrs = (PinAttributes)painter.getAttributeSet();
        Direction dir = attrs.facing;
        boolean output = attrs.isOutput();
        Graphics2D g = (Graphics2D)painter.getGraphics();
        int iconSize = AppPreferences.getIconSize();
        GraphicsUtil.switchToWidth(g, AppPreferences.getScaled(1));
        BitWidth w = attrs.getValue(StdAttr.WIDTH);
        int pinSize = iconSize >> 2;
        Color baseColor = g.getColor();
        if (attrs.getValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
            int arrowHeight = 10 * iconSize >> 4;
            int yoff = 3 * iconSize >> 4;
            int xoff = output ? pinSize : 0;
            int[] yPoints = new int[]{yoff, yoff, yoff + (arrowHeight >> 1), yoff + arrowHeight, yoff + arrowHeight};
            int[] xPoints = new int[]{xoff, xoff + iconSize - (pinSize << 1), xoff + iconSize - pinSize, xoff + iconSize - (pinSize << 1), xoff};
            g.setColor(baseColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
            g.setColor(Value.TRUE.getColor());
            GraphicsUtil.switchToWidth(g, AppPreferences.getScaled(2));
            if (output) {
                g.drawLine(0, yoff + (arrowHeight >> 1), pinSize, yoff + (arrowHeight >> 1));
            } else {
                g.drawLine(iconSize - pinSize, yoff + (arrowHeight >> 1), iconSize, yoff + (arrowHeight >> 1));
            }
        } else {
            int iconOffset = AppPreferences.getScaled(4);
            int boxWidth = iconSize - (iconOffset << 1);
            int pinWidth = AppPreferences.getScaled(3);
            int pinx = iconOffset + boxWidth;
            int piny = iconOffset + (boxWidth >> 1) - (pinWidth >> 1);
            if (dir == Direction.WEST) {
                pinx = iconOffset - pinWidth;
            } else if (dir == Direction.NORTH) {
                pinx = iconOffset + (boxWidth >> 1) - (pinWidth >> 1);
                piny = iconOffset - pinWidth;
            } else if (dir == Direction.SOUTH) {
                pinx = iconOffset + (boxWidth >> 1) - (pinWidth >> 1);
                piny = iconOffset + boxWidth;
            }
            g.setColor(baseColor);
            if (output) {
                g.drawOval(iconOffset, iconOffset, boxWidth, boxWidth);
            } else {
                g.drawRect(iconOffset, iconOffset, boxWidth, boxWidth);
            }
            g.setColor(Value.TRUE.getColor());
            g.fillOval(iconOffset + (boxWidth >> 2), iconOffset + (boxWidth >> 3), boxWidth >> 1, 3 * boxWidth >> 2);
            g.fillOval(pinx, piny, pinWidth, pinWidth);
        }
        if (!w.equals(BitWidth.ONE)) {
            g.setColor(ICON_WIDTH_COLOR);
            g.setFont(ICON_WIDTH_FONT);
            TextLayout bw = new TextLayout(Integer.toString(w.getWidth()), ICON_WIDTH_FONT, g.getFontRenderContext());
            float xpos = (float)AppPreferences.getIconSize() / 2.0f - (float)bw.getBounds().getCenterX();
            float ypos = (float)AppPreferences.getIconSize() / 2.0f - (float)bw.getBounds().getCenterY();
            if (attrs.getValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
                xpos = output ? (float)(pinSize + (iconSize - pinSize) / 2) - (float)bw.getBounds().getCenterX() : (float)((iconSize - pinSize) / 2) - (float)bw.getBounds().getCenterX();
            }
            bw.draw(g, xpos, ypos);
            g.setColor(baseColor);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        PinAttributes attrs = (PinAttributes)painter.getAttributeSet();
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getInstance().getBounds();
        boolean IsOutput = attrs.type == OUTPUT;
        PinState state = Pin.getState(painter);
        Value found = state.foundValue;
        int x = bds.getX();
        int y = bds.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        if (IsOutput) {
            this.drawOutputShape(painter, x + 1, y + 1, bds.getWidth() - 1, bds.getHeight() - 1, found.getColor(), false);
        } else {
            this.drawInputShape(painter, x + 1, y + 1, bds.getWidth() - 1, bds.getHeight() - 1, found.getColor(), false);
        }
        painter.drawLabel();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        PinAttributes attrs = (PinAttributes)state.getAttributeSet();
        PinState q = Pin.getState(state);
        Value found = state.getPortValue(0);
        if (attrs.type == OUTPUT) {
            q.foundValue = found;
            q.intendedValue = found;
        } else {
            q.foundValue = found;
            Value drive = this.pull(attrs, q.intendedValue);
            if (!drive.equals(found)) {
                state.setPort(0, drive, 1);
            }
        }
    }

    @Override
    public boolean requiresNonZeroLabel() {
        return true;
    }

    public void driveInputPin(InstanceState state, Value value) {
        PinAttributes attrs = (PinAttributes)state.getAttributeSet();
        PinState myState = Pin.getState(state);
        myState.intendedValue = value;
    }

    private Value pull(PinAttributes attrs, Value value) {
        if (value == Value.NIL) {
            return Value.createUnknown(attrs.width);
        }
        if (attrs.behavior == PULL_UP) {
            return value.pullEachBitTowards(Value.TRUE);
        }
        if (attrs.behavior == PULL_DOWN) {
            return value.pullEachBitTowards(Value.FALSE);
        }
        return value;
    }

    private static class PinState
    implements InstanceData,
    Cloneable {
        Value foundValue;
        Value intendedValue;

        private PinState() {
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class PinLogger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            PinAttributes attrs = (PinAttributes)state.getAttributeSet();
            String ret = attrs.label;
            if (ret == null || ret.equals("")) {
                String type = attrs.type == INPUT ? Strings.S.get("pinInputName") : Strings.S.get("pinOutputName");
                return type + String.valueOf(state.getInstance().getLocation());
            }
            return ret;
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.WIDTH);
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            PinState s = Pin.getState(state);
            return s.intendedValue;
        }

        @Override
        public boolean isInput(InstanceState state, Object option) {
            PinAttributes attrs = (PinAttributes)state.getAttributeSet();
            return attrs.type == INPUT;
        }
    }

    public static class PinPoker
    extends InstancePoker {
        int bitPressed = -1;
        int bitCaret = -1;

        private int getRow(InstanceState state, MouseEvent e) {
            int row = 0;
            Direction dir = state.getAttributeValue(StdAttr.FACING);
            Bounds bds = state.getInstance().getBounds();
            row = dir == Direction.EAST || dir == Direction.WEST ? (bds.getY() + bds.getHeight() - e.getY()) / 20 : (dir == Direction.NORTH ? (bds.getX() + bds.getWidth() - e.getX()) / 20 : (e.getX() - bds.getX()) / 20);
            return row;
        }

        private int getColumn(InstanceState state, MouseEvent e, boolean isBinair) {
            int col = 0;
            int distance = isBinair ? 10 : 8;
            Direction dir = state.getAttributeValue(StdAttr.FACING);
            Bounds bds = state.getInstance().getBounds();
            if (dir == Direction.EAST || dir == Direction.WEST) {
                int offset = dir == Direction.EAST ? 20 : 10;
                col = (bds.getX() + bds.getWidth() - e.getX() - offset) / distance;
            } else {
                col = dir == Direction.NORTH ? (e.getY() - bds.getY() - 20) / distance : (bds.getY() + bds.getHeight() - e.getY() - 20) / distance;
            }
            return col;
        }

        private int getBit(InstanceState state, MouseEvent e) {
            int bit;
            int j;
            int i;
            int r;
            RadixOption radix = state.getAttributeValue(RadixOption.ATTRIBUTE);
            BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
            if (radix == RadixOption.RADIX_16) {
                r = 4;
            } else if (radix == RadixOption.RADIX_8) {
                r = 3;
            } else if (radix == RadixOption.RADIX_2) {
                r = 1;
            } else {
                return -1;
            }
            if (width.getWidth() <= r) {
                return 0;
            }
            Bounds bds = state.getInstance().getBounds();
            if (state.getAttributeValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
                i = this.getColumn(state, e, r == 1);
                j = this.getRow(state, e);
            } else {
                i = (bds.getX() + bds.getWidth() - e.getX() - (r == 1 ? 0 : 4)) / (r == 1 ? 10 : 8);
                j = (bds.getY() + bds.getHeight() - e.getY() - 2) / 14;
            }
            int n = bit = r == 1 ? 8 * j + i : i * r;
            if (bit < 0 || bit >= width.getWidth()) {
                return -1;
            }
            return bit;
        }

        private boolean handleBitPress(InstanceState state, int bit, RadixOption radix, Component src, char ch) {
            int b;
            boolean tristate;
            int r;
            PinAttributes attrs = (PinAttributes)state.getAttributeSet();
            if (!attrs.isInput()) {
                return false;
            }
            if (src instanceof Canvas) {
                Canvas canvas = (Canvas)src;
                if (!state.isCircuitRoot()) {
                    CircuitState circState = canvas.getCircuitState();
                    Component frame = SwingUtilities.getRoot(canvas);
                    int choice = OptionPane.showConfirmDialog(frame, Strings.S.get("pinFrozenQuestion"), Strings.S.get("pinFrozenTitle"), 2, 2);
                    if (choice == 0) {
                        circState = circState.cloneAsNewRootState();
                        canvas.getProject().setCircuitState(circState);
                        state = circState.getInstanceState(state.getInstance());
                    } else {
                        return false;
                    }
                }
            }
            BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
            PinState pinState = Pin.getState(state);
            int n = radix == RadixOption.RADIX_16 ? 4 : (r = radix == RadixOption.RADIX_8 ? 3 : 1);
            if (bit + r > width.getWidth()) {
                r = width.getWidth() - bit;
            }
            Value[] val = pinState.intendedValue.getAll();
            boolean bl = tristate = attrs.behavior == TRISTATE;
            if (tristate) {
                for (b = 0; b < val.length; ++b) {
                    if (val[b] == Value.TRUE || val[b] == Value.FALSE || val[b] == Value.UNKNOWN) continue;
                    val[b] = Value.UNKNOWN;
                }
            } else {
                for (b = 0; b < val.length; ++b) {
                    if (val[b] == Value.TRUE || val[b] == Value.FALSE) continue;
                    val[b] = Value.TRUE;
                }
            }
            if (ch == '\u0000') {
                int b2;
                boolean ones = true;
                boolean defined = true;
                for (b2 = bit; b2 < bit + r; ++b2) {
                    if (val[b2] == Value.FALSE) {
                        ones = false;
                        continue;
                    }
                    if (val[b2] == Value.TRUE) continue;
                    defined = false;
                }
                if (!defined || ones && !tristate) {
                    for (b2 = bit; b2 < bit + r; ++b2) {
                        val[b2] = Value.FALSE;
                    }
                } else if (ones && tristate) {
                    for (b2 = bit; b2 < bit + r; ++b2) {
                        val[b2] = Value.UNKNOWN;
                    }
                } else {
                    int carry = 1;
                    Value[] v = new Value[]{Value.FALSE, Value.TRUE};
                    for (int b3 = bit; b3 < bit + r; ++b3) {
                        int s = (val[b3] == Value.TRUE ? 1 : 0) + carry;
                        val[b3] = v[s % 2];
                        carry = s / 2;
                    }
                }
            } else if (tristate && (ch == Character.toLowerCase(Value.UNKNOWNCHAR) || ch == Character.toUpperCase(Value.UNKNOWNCHAR))) {
                for (b = bit; b < bit + r; ++b) {
                    val[b] = Value.UNKNOWN;
                }
            } else {
                int d;
                if ('0' <= ch && ch <= '9') {
                    d = ch - 48;
                } else if ('a' <= ch && ch <= 'f') {
                    d = 10 + (ch - 97);
                } else if ('A' <= ch && ch <= 'F') {
                    d = 10 + (ch - 65);
                } else {
                    return false;
                }
                if (d >= 1 << r) {
                    return false;
                }
                for (int i = 0; i < r; ++i) {
                    val[bit + i] = (d & 1 << i) != 0 ? Value.TRUE : Value.FALSE;
                }
            }
            pinState.intendedValue = Value.create(val);
            state.fireInvalidated();
            return true;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.bitPressed = this.getBit(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!((PinAttributes)state.getAttributeSet()).isInput()) {
                this.bitPressed = -1;
                this.bitCaret = -1;
                return;
            }
            RadixOption radix = state.getAttributeValue(RadixOption.ATTRIBUTE);
            if (radix == RadixOption.RADIX_10_SIGNED || radix == RadixOption.RADIX_10_UNSIGNED) {
                EditDecimal dialog = new EditDecimal(state);
                dialog.setLocation(e.getXOnScreen() - 60, e.getYOnScreen() - 40);
                dialog.setVisible(true);
            } else if (radix == RadixOption.RADIX_FLOAT) {
                EditFloat dialog = new EditFloat(state);
                dialog.setLocation(e.getXOnScreen() - 60, e.getYOnScreen() - 40);
                dialog.setVisible(true);
            } else {
                int bit = this.getBit(state, e);
                if (bit == this.bitPressed && bit >= 0) {
                    this.bitCaret = bit;
                    this.handleBitPress(state, bit, radix, e.getComponent(), '\u0000');
                }
                if (this.bitCaret < 0) {
                    BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
                    int r = radix == RadixOption.RADIX_16 ? 4 : (radix == RadixOption.RADIX_8 ? 3 : 1);
                    this.bitCaret = (width.getWidth() - 1) / r * r;
                }
            }
            this.bitPressed = -1;
        }

        @Override
        public void keyTyped(InstanceState state, KeyEvent e) {
            char ch = e.getKeyChar();
            RadixOption radix = state.getAttributeValue(RadixOption.ATTRIBUTE);
            if (radix == RadixOption.RADIX_10_SIGNED || radix == RadixOption.RADIX_10_UNSIGNED) {
                return;
            }
            int r = radix == RadixOption.RADIX_16 ? 4 : (radix == RadixOption.RADIX_8 ? 3 : 1);
            BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
            if (this.bitCaret < 0) {
                this.bitCaret = (width.getWidth() - 1) / r * r;
            }
            if (this.handleBitPress(state, this.bitCaret, radix, e.getComponent(), ch)) {
                this.bitCaret -= r;
                if (this.bitCaret < 0) {
                    this.bitCaret = (width.getWidth() - 1) / r * r;
                }
            }
        }

        @Override
        public void paint(InstancePainter painter) {
            int r;
            if (this.bitCaret < 0) {
                return;
            }
            BitWidth width = painter.getAttributeValue(StdAttr.WIDTH);
            RadixOption radix = painter.getAttributeValue(RadixOption.ATTRIBUTE);
            if (radix == RadixOption.RADIX_10_SIGNED || radix == RadixOption.RADIX_10_UNSIGNED) {
                return;
            }
            int n = radix == RadixOption.RADIX_16 ? 4 : (r = radix == RadixOption.RADIX_8 ? 3 : 1);
            if (width.getWidth() <= r) {
                return;
            }
            Bounds bds = painter.getBounds();
            Graphics g = painter.getGraphics();
            g.setColor(Color.RED);
            int y = bds.getY() + bds.getHeight();
            int x = bds.getX() + bds.getWidth();
            if (painter.getAttributeValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
                Direction dir = painter.getAttributeValue(StdAttr.FACING);
                int distance = radix == RadixOption.RADIX_2 ? 10 : 8;
                int bwidth = 15;
                int bheight = distance - 1;
                if (dir == Direction.EAST || dir == Direction.WEST) {
                    int offset = dir == Direction.EAST ? 20 : 10;
                    x -= offset + distance * (radix == RadixOption.RADIX_2 ? this.bitCaret % 8 : this.bitCaret / r);
                    y -= radix == RadixOption.RADIX_2 ? 20 * (this.bitCaret / 8) : 0;
                    bwidth = distance - 1;
                    bheight = 15;
                    x -= bwidth;
                    y -= 18;
                } else if (dir == Direction.NORTH) {
                    y = bds.getY() + 21 + distance * (radix == RadixOption.RADIX_2 ? this.bitCaret % 8 : this.bitCaret / r);
                    x -= 18 + (radix == RadixOption.RADIX_2 ? 20 * (this.bitCaret / 8) : 0);
                } else {
                    y -= 19 + distance + distance * (radix == RadixOption.RADIX_2 ? this.bitCaret % 8 : this.bitCaret / r);
                    x = bds.getX() + 3 + (radix == RadixOption.RADIX_2 ? 20 * (this.bitCaret / 8) : 0);
                }
                g.drawRect(x, y, bwidth, bheight);
            } else {
                if (radix == RadixOption.RADIX_2) {
                    x -= 2 + 10 * (this.bitCaret % 8);
                    y -= 2 + 14 * (this.bitCaret / 8);
                } else {
                    x -= 4 + 8 * (this.bitCaret / r);
                    y -= 4;
                }
                GraphicsUtil.switchToWidth(g, 2);
                g.drawLine(x - 6, y, x, y);
            }
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        }
    }

    private static class EditFloat
    extends JDialog
    implements BaseKeyListenerContract,
    LocaleListener {
        private final JFormattedTextField text;
        private final int bitWidth;
        final PinState pinState;
        final InstanceState state;
        final boolean tristate;
        private static final Color VALID_COLOR = new Color(255, 240, 153);
        private static final Color INVALID_COLOR = new Color(255, 102, 102);
        final JButton ok;
        final JButton cancel;

        @Override
        public void localeChanged() {
            this.setTitle(Strings.S.get("PinEnterFloat"));
            this.ok.setText(Strings.S.get("PinOkay"));
            this.cancel.setText(Strings.S.get("PinCancel"));
        }

        public EditFloat(InstanceState state) {
            this.state = state;
            this.pinState = Pin.getState(state);
            Value value = this.pinState.intendedValue;
            this.bitWidth = value.getWidth();
            PinAttributes attrs = (PinAttributes)state.getAttributeSet();
            this.tristate = attrs.behavior == TRISTATE;
            this.setTitle(Strings.S.get("PinEnterFloat"));
            GridBagConstraints gbc = new GridBagConstraints();
            this.ok = new JButton(Strings.S.get("PinOkay"));
            this.cancel = new JButton(Strings.S.get("PinCancel"));
            this.ok.addActionListener(e -> this.accept());
            this.cancel.addActionListener(e -> this.setVisible(false));
            this.addWindowFocusListener(new BaseWindowFocusListenerContract(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
            this.setLayout(new GridBagLayout());
            this.text = new JFormattedTextField();
            this.text.setFont(AppPreferences.getScaledFont(DEFAULT_FONT));
            this.text.setColumns(11);
            this.text.setText(value.toStringFromFloatValue());
            this.text.selectAll();
            this.text.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String s = text.getText();
                    if (this.isEditValid(s)) {
                        text.setBackground(VALID_COLOR);
                        ok.setEnabled(true);
                    } else {
                        text.setBackground(INVALID_COLOR);
                        ok.setEnabled(false);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.insertUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.add((Component)this.cancel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.add((Component)this.ok, gbc);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            gbc.anchor = 256;
            gbc.insets = new Insets(8, 4, 8, 4);
            this.text.addKeyListener(this);
            this.text.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.text.setBackground(VALID_COLOR);
            this.add((Component)this.text, gbc);
            this.pack();
        }

        public void accept() {
            String s = this.text.getText();
            if (this.isEditValid(s)) {
                Value newVal;
                if (s.equals(Character.toString(Value.UNKNOWNCHAR).toLowerCase()) || s.equals(Character.toString(Value.UNKNOWNCHAR).toUpperCase()) || s.equals("???")) {
                    newVal = Value.createUnknown(BitWidth.create(this.bitWidth));
                } else {
                    double val = s.equalsIgnoreCase("inf") || s.equalsIgnoreCase("+inf") ? Double.POSITIVE_INFINITY : (s.equalsIgnoreCase("-inf") ? Double.NEGATIVE_INFINITY : (s.equalsIgnoreCase("nan") ? Double.NaN : Double.parseDouble(s)));
                    newVal = switch (this.bitWidth) {
                        case 16 -> Value.createKnown(16, (long)Float.floatToFloat16((float)val));
                        case 32 -> Value.createKnown((float)val);
                        case 64 -> Value.createKnown(val);
                        default -> Value.ERROR;
                    };
                }
                this.setVisible(false);
                this.pinState.intendedValue = newVal;
                this.state.fireInvalidated();
            }
        }

        boolean isEditValid(String s) {
            if (s == null) {
                return false;
            }
            if ((s = s.trim()).equals("")) {
                return false;
            }
            if (this.tristate && (s.equals(Character.toString(Value.UNKNOWNCHAR).toLowerCase()) || s.equals(Character.toString(Value.UNKNOWNCHAR).toUpperCase()) || s.equals("???"))) {
                return true;
            }
            if (s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("inf") || s.equalsIgnoreCase("+inf") || s.equalsIgnoreCase("-inf")) {
                return true;
            }
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.accept();
            } else if (e.getKeyCode() == 27) {
                this.setVisible(false);
            }
        }
    }

    private static class EditDecimal
    extends JDialog
    implements BaseKeyListenerContract,
    LocaleListener {
        private final JFormattedTextField text;
        private final int bitWidth;
        final PinState pinState;
        final InstanceState state;
        final RadixOption radix;
        final boolean tristate;
        private static final Color VALID_COLOR = new Color(255, 240, 153);
        private static final Color INVALID_COLOR = new Color(255, 102, 102);
        final JButton ok;
        final JButton cancel;

        @Override
        public void localeChanged() {
            this.setTitle(Strings.S.get("PinEnterDecimal"));
            this.ok.setText(Strings.S.get("PinOkay"));
            this.cancel.setText(Strings.S.get("PinCancel"));
        }

        public EditDecimal(InstanceState state) {
            this.state = state;
            this.radix = state.getAttributeValue(RadixOption.ATTRIBUTE);
            this.pinState = Pin.getState(state);
            Value value = this.pinState.intendedValue;
            this.bitWidth = value.getWidth();
            PinAttributes attrs = (PinAttributes)state.getAttributeSet();
            this.tristate = attrs.behavior == TRISTATE;
            this.setTitle(Strings.S.get("PinEnterDecimal"));
            GridBagConstraints gbc = new GridBagConstraints();
            this.ok = new JButton(Strings.S.get("PinOkay"));
            this.cancel = new JButton(Strings.S.get("PinCancel"));
            this.ok.addActionListener(e -> this.accept());
            this.cancel.addActionListener(e -> this.setVisible(false));
            this.addWindowFocusListener(new BaseWindowFocusListenerContract(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
            this.setLayout(new GridBagLayout());
            this.text = new JFormattedTextField();
            this.text.setFont(AppPreferences.getScaledFont(DEFAULT_FONT));
            this.text.setColumns(11);
            this.text.setText(value.toDecimalString(this.radix == RadixOption.RADIX_10_SIGNED));
            this.text.selectAll();
            this.text.getDocument().addDocumentListener(new BaseDocumentListenerContract(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String s = text.getText();
                    if (this.isEditValid(s)) {
                        text.setBackground(VALID_COLOR);
                        ok.setEnabled(true);
                    } else {
                        text.setBackground(INVALID_COLOR);
                        ok.setEnabled(false);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.insertUpdate(e);
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.add((Component)this.cancel, gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.add((Component)this.ok, gbc);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            gbc.anchor = 256;
            gbc.insets = new Insets(8, 4, 8, 4);
            this.text.addKeyListener(this);
            this.text.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.text.setBackground(VALID_COLOR);
            this.add((Component)this.text, gbc);
            this.pack();
        }

        public void accept() {
            String s = this.text.getText();
            if (this.isEditValid(s)) {
                Value newVal;
                if (s.equals(Character.toString(Value.UNKNOWNCHAR).toLowerCase()) || s.equals(Character.toString(Value.UNKNOWNCHAR).toUpperCase()) || s.equals("???")) {
                    newVal = Value.createUnknown(BitWidth.create(this.bitWidth));
                } else {
                    try {
                        BigInteger n = new BigInteger(s);
                        BigInteger signedMax = new BigInteger("1").shiftLeft(this.bitWidth - 1);
                        if (this.radix == RadixOption.RADIX_10_SIGNED || n.compareTo(signedMax) < 0) {
                            newVal = Value.createKnown(BitWidth.create(this.bitWidth), n.longValue());
                        } else {
                            BigInteger max = new BigInteger("1").shiftLeft(this.bitWidth);
                            BigInteger newValue = n.subtract(max);
                            newVal = Value.createKnown(BitWidth.create(this.bitWidth), newValue.longValue());
                        }
                    }
                    catch (NumberFormatException exception) {
                        return;
                    }
                }
                this.setVisible(false);
                this.pinState.intendedValue = newVal;
                this.state.fireInvalidated();
            }
        }

        boolean isEditValid(String s) {
            if (s == null) {
                return false;
            }
            if ((s = s.trim()).equals("")) {
                return false;
            }
            if (this.tristate && (s.equals(Character.toString(Value.UNKNOWNCHAR).toLowerCase()) || s.equals(Character.toString(Value.UNKNOWNCHAR).toUpperCase()) || s.equals("???"))) {
                return true;
            }
            try {
                BigInteger n = new BigInteger(s);
                if (this.radix == RadixOption.RADIX_10_SIGNED) {
                    BigInteger min = new BigInteger("-1").shiftLeft(this.bitWidth - 1);
                    BigInteger max = new BigInteger("1").shiftLeft(this.bitWidth - 1);
                    return n.compareTo(min) >= 0 && n.compareTo(max) < 0;
                }
                BigInteger max = new BigInteger("1").shiftLeft(this.bitWidth);
                return n.compareTo(BigInteger.ZERO) >= 0 && n.compareTo(max) < 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.accept();
            } else if (e.getKeyCode() == 27) {
                this.setVisible(false);
            }
        }
    }
}

