/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.data.Bounds;

public class MatrixPlacerInfo {
    private final String oldLabel;
    private String sharedLabel;
    private int copiesCountX = 1;
    private int copiesCountY = 1;
    private int displacementX = 1;
    private int displacementY = 1;
    private int minimalDisplacementX = 1;
    private int minilamDisplacementY = 1;

    public MatrixPlacerInfo(String label) {
        this.sharedLabel = label;
        this.oldLabel = label;
    }

    void setBounds(Bounds bds) {
        this.displacementX = this.minimalDisplacementX = (bds.getWidth() + 9) / 10;
        this.displacementY = this.minilamDisplacementY = (bds.getHeight() + 9) / 10;
    }

    int getMinimalDisplacementX() {
        return this.minimalDisplacementX;
    }

    int getMinimalDisplacementY() {
        return this.minilamDisplacementY;
    }

    String getLabel() {
        return this.sharedLabel;
    }

    void undoLabel() {
        this.sharedLabel = this.oldLabel;
    }

    void setLabel(String lab) {
        this.sharedLabel = lab;
    }

    int getCopiesCountX() {
        return this.copiesCountX;
    }

    void setCopiesCountX(int val) {
        this.copiesCountX = val;
    }

    int getCopiesCountY() {
        return this.copiesCountY;
    }

    void setCopiesCountY(int val) {
        this.copiesCountY = val;
    }

    int getDeltaX() {
        return this.displacementX * 10;
    }

    void setDeltaX(int value) {
        if (value > 0) {
            this.displacementX = (value + 9) / 10;
        }
    }

    void setDisplacementX(int value) {
        if (value > 0) {
            this.displacementX = value;
        }
    }

    int getDisplacementX() {
        return this.displacementX;
    }

    int getDeltaY() {
        return this.displacementY * 10;
    }

    void setDeltaY(int value) {
        if (value > 0) {
            this.displacementY = (value + 9) / 10;
        }
    }

    void setDisplacementY(int value) {
        if (value > 0) {
            this.displacementY = value;
        }
    }

    int getDisplacementY() {
        return this.displacementY;
    }
}

