/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.CircuitTransactionResult;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.List;

public class SetAttributeAction
extends Action {
    private final StringGetter nameGetter;
    private final Circuit circuit;
    private final List<Component> comps;
    private final List<Attribute<Object>> attrs;
    private final List<Object> values;
    private final List<Object> oldValues;
    private CircuitTransaction xnReverse;

    public SetAttributeAction(Circuit circuit, StringGetter nameGetter) {
        this.nameGetter = nameGetter;
        this.circuit = circuit;
        this.comps = new ArrayList<Component>();
        this.attrs = new ArrayList<Attribute<Object>>();
        this.values = new ArrayList<Object>();
        this.oldValues = new ArrayList<Object>();
    }

    @Override
    public void doIt(Project proj) {
        CircuitMutation xn = new CircuitMutation(this.circuit);
        int len = this.values.size();
        this.oldValues.clear();
        for (int i = 0; i < len; ++i) {
            Component comp = this.comps.get(i);
            Attribute<Object> attr = this.attrs.get(i);
            Object value = this.values.get(i);
            if (this.circuit.contains(comp)) {
                this.oldValues.add(null);
                xn.set(comp, attr, value);
                continue;
            }
            AttributeSet compAttrs = comp.getAttributeSet();
            this.oldValues.add(compAttrs.getValue(attr));
            compAttrs.setValue(attr, value);
        }
        if (!xn.isEmpty()) {
            CircuitTransactionResult result = xn.execute();
            this.xnReverse = result.getReverseTransaction();
        }
    }

    @Override
    public String getName() {
        return this.nameGetter.toString();
    }

    public boolean isEmpty() {
        return this.comps.isEmpty();
    }

    public void set(Component comp, Attribute<?> attr, Object value) {
        Attribute<?> a = attr;
        this.comps.add(comp);
        this.attrs.add(a);
        this.values.add(value);
    }

    @Override
    public void undo(Project proj) {
        if (this.xnReverse != null) {
            this.xnReverse.execute();
        }
        for (int i = this.oldValues.size() - 1; i >= 0; --i) {
            Component comp = this.comps.get(i);
            Attribute<Object> attr = this.attrs.get(i);
            Object value = this.oldValues.get(i);
            if (value == null) continue;
            comp.getAttributeSet().setValue(attr, value);
        }
    }
}

