/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.CaretEvent;
import com.cburch.logisim.tools.CaretListener;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.TextEditable;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.StringUtil;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TextTool
extends Tool {
    public static final String _ID = "Text Tool";
    private static final Cursor cursor = Cursor.getPredefinedCursor(2);
    private final MyListener listener = new MyListener();
    private final AttributeSet attrs = Text.FACTORY.createAttributeSet();
    private Caret caret = null;
    private boolean caretCreatingText = false;
    private Canvas caretCanvas = null;
    private Circuit caretCircuit = null;
    private Component caretComponent = null;

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        return Text.FACTORY.getDefaultAttributeValue(attr, ver);
    }

    @Override
    public void deselect(Canvas canvas) {
        if (this.caret != null) {
            this.caret.stopEditing();
            this.caret = null;
        }
    }

    @Override
    public void draw(Canvas canvas, ComponentDrawContext context) {
        if (this.caret != null) {
            this.caret.draw(context.getGraphics());
        }
    }

    public boolean equals(Object other) {
        return other instanceof TextTool;
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    @Override
    public Cursor getCursor() {
        return cursor;
    }

    @Override
    public String getDescription() {
        return Strings.S.get("textToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("textTool");
    }

    public int hashCode() {
        return TextTool.class.hashCode();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        if (this.caret != null) {
            this.caret.keyPressed(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        if (this.caret != null) {
            this.caret.keyReleased(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        if (this.caret != null) {
            this.caret.keyTyped(e);
            canvas.getProject().repaintCanvas();
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, Graphics g, MouseEvent e) {
        Project proj = canvas.getProject();
        Circuit circ = canvas.getCircuit();
        if (!proj.getLogisimFile().contains(circ)) {
            if (this.caret != null) {
                this.caret.cancelEditing();
            }
            canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
            return;
        }
        if (this.caret != null) {
            this.caret.mouseDragged(e);
            proj.repaintCanvas();
        }
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        TextEditable editable;
        Project proj = canvas.getProject();
        Circuit circ = canvas.getCircuit();
        Action act = SelectionActions.dropAll(canvas.getSelection());
        canvas.getProject().doAction(act);
        if (!proj.getLogisimFile().contains(circ)) {
            if (this.caret != null) {
                this.caret.cancelEditing();
            }
            canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
            return;
        }
        if (this.caret != null) {
            if (this.caret.getBounds(g).contains(e.getX(), e.getY())) {
                this.caret.mousePressed(e);
                proj.repaintCanvas();
                return;
            }
            this.caret.stopEditing();
        }
        int x = e.getX();
        int y = e.getY();
        Location loc = Location.create(x, y, false);
        ComponentUserEvent event = new ComponentUserEvent(canvas, x, y);
        for (Component comp : proj.getSelection().getComponentsContaining(loc, g)) {
            editable = (TextEditable)comp.getFeature(TextEditable.class);
            if (editable == null) continue;
            this.caret = editable.getTextCaret(event);
            if (this.caret == null) continue;
            proj.getFrame().viewComponentAttributes(circ, comp);
            this.caretComponent = comp;
            this.caretCreatingText = false;
            break;
        }
        if (this.caret == null) {
            for (Component comp : circ.getAllContaining(loc, g)) {
                editable = (TextEditable)comp.getFeature(TextEditable.class);
                if (editable == null) continue;
                this.caret = editable.getTextCaret(event);
                if (this.caret == null) continue;
                proj.getFrame().viewComponentAttributes(circ, comp);
                this.caretComponent = comp;
                this.caretCreatingText = false;
                break;
            }
        }
        if (this.caret == null) {
            if (loc.getX() < 0 || loc.getY() < 0) {
                return;
            }
            AttributeSet copy = (AttributeSet)this.attrs.clone();
            this.caretComponent = Text.FACTORY.createComponent(loc, copy);
            this.caretCreatingText = true;
            TextEditable editable2 = (TextEditable)this.caretComponent.getFeature(TextEditable.class);
            if (editable2 != null) {
                this.caret = editable2.getTextCaret(event);
                proj.getFrame().viewComponentAttributes(circ, this.caretComponent);
            }
        }
        if (this.caret != null) {
            this.caretCanvas = canvas;
            this.caretCircuit = canvas.getCircuit();
            this.caret.addCaretListener(this.listener);
            this.caretCircuit.addCircuitListener(this.listener);
        }
        proj.repaintCanvas();
    }

    @Override
    public void mouseReleased(Canvas canvas, Graphics g, MouseEvent e) {
        Project proj = canvas.getProject();
        Circuit circ = canvas.getCircuit();
        if (!proj.getLogisimFile().contains(circ)) {
            if (this.caret != null) {
                this.caret.cancelEditing();
            }
            canvas.setErrorMessage(Strings.S.getter("cannotModifyError"));
            return;
        }
        if (this.caret != null) {
            this.caret.mouseReleased(e);
            proj.repaintCanvas();
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        Text.FACTORY.paintIcon(c, x, y, null);
    }

    private class MyListener
    implements CaretListener,
    CircuitListener {
        private MyListener() {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            if (event.getCircuit() != TextTool.this.caretCircuit) {
                event.getCircuit().removeCircuitListener(this);
                return;
            }
            int action = event.getAction();
            if (action == 2) {
                if (event.getData() == TextTool.this.caretComponent) {
                    TextTool.this.caret.cancelEditing();
                }
            } else if (action == 5 && TextTool.this.caretComponent != null) {
                TextTool.this.caret.cancelEditing();
            }
        }

        @Override
        public void editingCanceled(CaretEvent e) {
            if (e.getCaret() != TextTool.this.caret) {
                e.getCaret().removeCaretListener(this);
                return;
            }
            TextTool.this.caret.removeCaretListener(this);
            TextTool.this.caretCircuit.removeCircuitListener(this);
            TextTool.this.caretCircuit = null;
            TextTool.this.caretComponent = null;
            TextTool.this.caretCreatingText = false;
            TextTool.this.caret = null;
        }

        @Override
        public void editingStopped(CaretEvent e) {
            Action a;
            if (e.getCaret() != TextTool.this.caret) {
                e.getCaret().removeCaretListener(this);
                return;
            }
            TextTool.this.caret.removeCaretListener(this);
            TextTool.this.caretCircuit.removeCircuitListener(this);
            String val = TextTool.this.caret.getText();
            boolean isEmpty = StringUtil.isNullOrEmpty(val);
            Project proj = TextTool.this.caretCanvas.getProject();
            if (TextTool.this.caretCreatingText) {
                if (!isEmpty) {
                    CircuitMutation xn = new CircuitMutation(TextTool.this.caretCircuit);
                    xn.add(TextTool.this.caretComponent);
                    a = xn.toAction(Strings.S.getter("addComponentAction", Text.FACTORY.getDisplayGetter()));
                } else {
                    a = null;
                }
            } else if (isEmpty && TextTool.this.caretComponent.getFactory() instanceof Text) {
                CircuitMutation xn = new CircuitMutation(TextTool.this.caretCircuit);
                xn.add(TextTool.this.caretComponent);
                a = xn.toAction(Strings.S.getter("removeComponentAction", Text.FACTORY.getDisplayGetter()));
            } else {
                Object obj = TextTool.this.caretComponent.getFeature(TextEditable.class);
                if (obj == null) {
                    a = null;
                } else {
                    TextEditable editable = (TextEditable)obj;
                    a = editable.getCommitAction(TextTool.this.caretCircuit, e.getOldText(), e.getText());
                }
            }
            TextTool.this.caretCircuit = null;
            TextTool.this.caretComponent = null;
            TextTool.this.caretCreatingText = false;
            TextTool.this.caret = null;
            if (a != null) {
                proj.doAction(a);
            }
        }
    }
}

