/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.tools.move.ConnectionData;
import com.cburch.logisim.tools.move.MoveRequest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;

public class MoveResult {
    private final ReplacementMap replacements;
    private final Collection<ConnectionData> unsatisfiedConnections;
    private final Collection<Location> unconnectedLocations;
    private final int totalDistance;

    public MoveResult(MoveRequest request, ReplacementMap replacements, Collection<ConnectionData> unsatisfiedConnections, int totalDistance) {
        this.replacements = replacements;
        this.unsatisfiedConnections = unsatisfiedConnections;
        this.totalDistance = totalDistance;
        ArrayList<Location> unconnected = new ArrayList<Location>();
        for (ConnectionData conn : unsatisfiedConnections) {
            unconnected.add(conn.getLocation());
        }
        this.unconnectedLocations = unconnected;
    }

    void addUnsatisfiedConnections(Collection<ConnectionData> toAdd) {
        this.unsatisfiedConnections.addAll(toAdd);
        for (ConnectionData conn : toAdd) {
            this.unconnectedLocations.add(conn.getLocation());
        }
    }

    public ReplacementMap getReplacementMap() {
        return this.replacements;
    }

    int getTotalDistance() {
        return this.totalDistance;
    }

    public Collection<Location> getUnconnectedLocations() {
        return this.unconnectedLocations;
    }

    Collection<ConnectionData> getUnsatisifiedConnections() {
        return this.unsatisfiedConnections;
    }

    public Collection<Wire> getWiresToAdd() {
        return this.replacements.getAdditions();
    }

    public void print(PrintStream out) {
        out.print("MoveResult: ");
        this.replacements.print(out);
    }

    public String toString() {
        return "MoveResult: " + this.replacements.toString();
    }
}

