/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    private IteratorUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static <E> Iterator<E> createJoinedIterator(Iterator<? extends E> i0, Iterator<? extends E> i1) {
        if (!i0.hasNext()) {
            Iterator<E> ret = i1;
            return ret;
        }
        if (!i1.hasNext()) {
            Iterator<E> ret = i0;
            return ret;
        }
        return new IteratorUnion<E>(i0, i1);
    }

    public static <E> Iterator<E> emptyIterator() {
        return new EmptyIterator();
    }

    private static final class IteratorUnion<E>
    implements Iterator<E> {
        Iterator<? extends E> cur;
        final Iterator<? extends E> next;

        private IteratorUnion(Iterator<? extends E> cur, Iterator<? extends E> next) {
            this.cur = cur;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.cur.hasNext() || this.next != null && this.next.hasNext();
        }

        @Override
        public E next() {
            if (!this.cur.hasNext()) {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.cur = this.next;
                if (!this.cur.hasNext()) {
                    throw new NoSuchElementException();
                }
            }
            return this.cur.next();
        }

        @Override
        public void remove() {
            this.cur.remove();
        }
    }

    private static final class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("EmptyIterator.remove");
        }
    }
}

