/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.QNode;
import com.cburch.logisim.util.QNodeQueue;

public class SplayQueue<T extends QNode>
implements QNodeQueue<T> {
    private QNode root;
    private int size;

    @Override
    public boolean add(T t) {
        if (this.root == null) {
            this.root = t;
            ++this.size;
            return true;
        }
        this.root = SplayQueue.splay(this.root, t);
        long cmp = ((QNode)t).compareTo(this.root);
        if (cmp < 0L) {
            ((QNode)t).left = this.root.left;
            ((QNode)t).right = this.root;
            this.root.left = null;
            this.root = t;
            ++this.size;
        } else if (cmp > 0L) {
            ((QNode)t).right = this.root.right;
            ((QNode)t).left = this.root;
            this.root.right = null;
            this.root = t;
            ++this.size;
        } else {
            throw new IllegalArgumentException("SplayQueue keys must be unique");
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    private static QNode splay(QNode t, QNode k) {
        if (t == null) {
            return null;
        }
        long cmp1 = k.compareTo(t);
        if (cmp1 < 0L) {
            if (t.left == null) {
                return t;
            }
            long cmp2 = k.compareTo(t.left);
            if (cmp2 < 0L) {
                t.left.left = SplayQueue.splay(t.left.left, k);
                t = SplayQueue.rotateRight(t);
            } else if (cmp2 > 0L) {
                t.left.right = SplayQueue.splay(t.left.right, k);
                if (t.left.right != null) {
                    t.left = SplayQueue.rotateLeft(t.left);
                }
            }
            return t.left == null ? t : SplayQueue.rotateRight(t);
        }
        if (cmp1 > 0L) {
            if (t.right == null) {
                return t;
            }
            long cmp2 = k.compareTo(t.right);
            if (cmp2 < 0L) {
                t.right.left = SplayQueue.splay(t.right.left, k);
                if (t.right.left != null) {
                    t.right = SplayQueue.rotateRight(t.right);
                }
            } else if (cmp2 > 0L) {
                t.right.right = SplayQueue.splay(t.right.right, k);
                t = SplayQueue.rotateLeft(t);
            }
            return t.right == null ? t : SplayQueue.rotateLeft(t);
        }
        return t;
    }

    private static QNode splay(QNode t) {
        if (t == null) {
            return null;
        }
        if (t.left == null) {
            return t;
        }
        t.left.left = SplayQueue.splay(t.left.left);
        t = SplayQueue.rotateRight(t);
        return t.left == null ? t : SplayQueue.rotateRight(t);
    }

    private static QNode rotateRight(QNode t) {
        QNode x = t.left;
        t.left = x.right;
        x.right = t;
        return x;
    }

    private static QNode rotateLeft(QNode t) {
        QNode x = t.right;
        t.right = x.left;
        x.left = t;
        return x;
    }

    @Override
    public T peek() {
        if (this.root == null) {
            return null;
        }
        QNode ret = this.root = SplayQueue.splay(this.root);
        return (T)ret;
    }

    @Override
    public T remove() {
        if (this.root == null) {
            return null;
        }
        --this.size;
        QNode t = SplayQueue.splay(this.root);
        this.root = t.right;
        return (T)t;
    }
}

