/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SyntaxChecker {
    private static final Pattern variablePattern = Pattern.compile("^([a-zA-Z]+\\w*)");
    private static final Pattern forbiddenPattern = Pattern.compile("__");

    private SyntaxChecker() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static String getErrorMessage(String val) {
        String message;
        if (StringUtil.isNullOrEmpty(val)) {
            return null;
        }
        StringBuilder messageBuilder = new StringBuilder();
        SyntaxChecker.buildVariableErrorMessage(val, messageBuilder);
        String hdl = CorrectLabel.hdlCorrectLabel(val);
        if (hdl != null) {
            messageBuilder.append(hdl.equals("VHDL") ? Strings.S.get("variableVHDLKeyword") : Strings.S.get("variableVerilogKeyword"));
        }
        if (val.endsWith("_")) {
            messageBuilder.append(Strings.S.get("variableEndsWithUndescore"));
        }
        return (message = messageBuilder.toString()).length() == 0 ? null : message;
    }

    private static void buildVariableErrorMessage(String val, StringBuilder messageBuilder) {
        Matcher variableMatcher = variablePattern.matcher(val);
        Matcher forbiddenMatcher = forbiddenPattern.matcher(val);
        if (!variableMatcher.matches()) {
            messageBuilder.append(Strings.S.get("variableInvalidCharacters"));
        }
        if (Character.isDigit(val.charAt(0))) {
            messageBuilder.append(Strings.S.get("variableStartsWithDigit"));
        } else {
            int firstIllegalCharacterIndex;
            variableMatcher.reset();
            int n = firstIllegalCharacterIndex = variableMatcher.find() ? variableMatcher.end() : 0;
            if (firstIllegalCharacterIndex != val.length()) {
                char firstIllegalCharacter = val.charAt(firstIllegalCharacterIndex);
                messageBuilder.append(Strings.S.get("variableIllegalCharacter", String.valueOf(firstIllegalCharacter)));
            }
        }
        if (forbiddenMatcher.find()) {
            messageBuilder.append(Strings.S.get("variableDoubleUnderscore"));
        }
    }

    public static boolean isVariableNameAcceptable(String val, Boolean showDialog) {
        String message = SyntaxChecker.getErrorMessage(val);
        if (message != null && showDialog.booleanValue()) {
            OptionPane.showMessageDialog(null, message.concat("\n" + Strings.S.get("variableNameNotAcceptable")));
        }
        return message == null;
    }
}

