/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.contracts.BaseLayoutManagerContract;
import com.cburch.logisim.util.HorizontalSplitPane;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class VerticalSplitPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JComponent compLeft;
    protected JComponent compRight;
    protected final MyDragbar dragbar = new MyDragbar();
    protected double fraction;
    protected MyLayout layout = new MyLayout();

    protected VerticalSplitPane() {
    }

    public VerticalSplitPane(JComponent compLeft, JComponent compRight, double fraction) {
        this.init(compLeft, compRight, fraction);
    }

    protected void init(JComponent compLeft, JComponent compRight, double fraction) {
        this.removeAll();
        this.compLeft = compLeft;
        this.compRight = compRight;
        this.fraction = fraction;
        this.setLayout(this.layout);
        this.add(this.dragbar);
        this.add(compLeft);
        this.add(compRight);
    }

    public double getFraction() {
        return this.fraction;
    }

    public void setFraction(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        if (this.fraction != value) {
            this.fraction = value;
            this.revalidate();
        }
    }

    private class MyDragbar
    extends HorizontalSplitPane.Dragbar {
        private static final long serialVersionUID = 1L;

        MyDragbar() {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }

        @Override
        int getDragValue(MouseEvent e) {
            return this.getX() + e.getX() - VerticalSplitPane.this.getInsets().left;
        }

        @Override
        void setDragValue(int value) {
            Insets in = VerticalSplitPane.this.getInsets();
            VerticalSplitPane.this.setFraction((double)value / (double)(VerticalSplitPane.this.getWidth() - in.left - in.right));
            this.revalidate();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }

    private class MyLayout
    implements BaseLayoutManagerContract {
        private MyLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int split;
            Insets in = parent.getInsets();
            int maxWidth = parent.getWidth() - (in.left + in.right);
            int maxHeight = parent.getHeight() - (in.top + in.bottom);
            if (VerticalSplitPane.this.fraction <= 0.0) {
                split = 0;
            } else if (VerticalSplitPane.this.fraction >= 1.0) {
                split = maxWidth;
            } else {
                split = (int)Math.round((double)maxWidth * VerticalSplitPane.this.fraction);
                split = Math.min(split, maxWidth - VerticalSplitPane.this.compRight.getMinimumSize().width);
                split = Math.max(split, VerticalSplitPane.this.compLeft.getMinimumSize().width);
            }
            VerticalSplitPane.this.compLeft.setBounds(in.left, in.top, split, maxHeight);
            VerticalSplitPane.this.compRight.setBounds(in.left + split, in.top, maxWidth - split, maxHeight);
            VerticalSplitPane.this.dragbar.setBounds(in.left + split - 3, in.top, 6, maxHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            if (VerticalSplitPane.this.fraction <= 0.0) {
                return VerticalSplitPane.this.compRight.getMinimumSize();
            }
            if (VerticalSplitPane.this.fraction >= 1.0) {
                return VerticalSplitPane.this.compLeft.getMinimumSize();
            }
            Insets in = parent.getInsets();
            Dimension d0 = VerticalSplitPane.this.compLeft.getMinimumSize();
            Dimension d1 = VerticalSplitPane.this.compRight.getMinimumSize();
            return new Dimension(in.left + d0.width + d1.width + in.right, in.top + Math.max(d0.height, d1.height) + in.bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (VerticalSplitPane.this.fraction <= 0.0) {
                return VerticalSplitPane.this.compRight.getPreferredSize();
            }
            if (VerticalSplitPane.this.fraction >= 1.0) {
                return VerticalSplitPane.this.compLeft.getPreferredSize();
            }
            Insets in = parent.getInsets();
            Dimension d0 = VerticalSplitPane.this.compLeft.getPreferredSize();
            Dimension d1 = VerticalSplitPane.this.compRight.getPreferredSize();
            return new Dimension(in.left + d0.width + d1.width + in.right, in.top + Math.max(d0.height, d1.height) + in.bottom);
        }
    }
}

