/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Heading
extends Block
implements AnchorRefTarget {
    protected int level;
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected String anchorRefId = "";
    protected boolean explicitAnchorRefId = false;

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        Heading.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public String getAnchorRefText() {
        boolean trimLeadingSpaces = HtmlRenderer.HEADER_ID_REF_TEXT_TRIM_LEADING_SPACES.get(this.getDocument());
        boolean trimTrailingSpaces = HtmlRenderer.HEADER_ID_REF_TEXT_TRIM_TRAILING_SPACES.get(this.getDocument());
        return new TextCollectingVisitor().collectAndGetText(this, TextContainer.F_FOR_HEADING_ID + (trimLeadingSpaces ? 0 : TextContainer.F_NO_TRIM_REF_TEXT_START) + (trimTrailingSpaces ? 0 : TextContainer.F_NO_TRIM_REF_TEXT_END));
    }

    @Override
    public String getAnchorRefId() {
        return this.anchorRefId;
    }

    @Override
    public void setAnchorRefId(String anchorRefId) {
        this.anchorRefId = anchorRefId;
    }

    @Override
    public boolean isExplicitAnchorRefId() {
        return this.explicitAnchorRefId;
    }

    @Override
    public void setExplicitAnchorRefId(boolean explicitAnchorRefId) {
        this.explicitAnchorRefId = explicitAnchorRefId;
    }

    public Heading() {
    }

    public Heading(BasedSequence chars) {
        super(chars);
    }

    public Heading(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public Heading(BlockContent blockContent) {
        super(blockContent);
    }

    public boolean isAtxHeading() {
        return this.openingMarker != BasedSequence.NULL;
    }

    public boolean isSetextHeading() {
        return this.openingMarker == BasedSequence.NULL && this.closingMarker != BasedSequence.NULL;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker == null ? BasedSequence.NULL : openingMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text == null ? BasedSequence.NULL : text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker == null ? BasedSequence.NULL : closingMarker;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

