/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;

public class TextNodeMergingList {
    private ArrayList<Node> list = new ArrayList();
    private boolean isMerged = true;

    public void add(Node node) {
        this.list.add(node);
        if (node instanceof Text) {
            this.isMerged = false;
        }
    }

    public void add(BasedSequence nodeChars) {
        if (!nodeChars.isEmpty()) {
            this.add(new Text(nodeChars));
        }
    }

    public void addChildrenOf(Node parent) {
        Node child = parent.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNext();
            child.unlink();
            this.add(child);
            child = nextChild;
        }
    }

    public void appendMergedTo(Node parent) {
        this.mergeList();
        for (Node child : this.list) {
            parent.appendChild(child);
        }
    }

    public void clear() {
        this.list.clear();
        this.isMerged = true;
    }

    public void insertMergedBefore(Node sibling) {
        this.mergeList();
        for (Node node : this.list) {
            sibling.insertBefore(node);
        }
        this.clear();
    }

    public void insertMergedAfter(Node sibling) {
        this.mergeList();
        for (Node node : this.list) {
            sibling.insertAfter(node);
            sibling = node;
        }
        this.clear();
    }

    private void mergeList() {
        if (!this.isMerged) {
            ArrayList<Node> mergedList = null;
            Node lastText = null;
            for (Node child : this.list) {
                if (child instanceof Text) {
                    if (child.getChars().isEmpty()) continue;
                    if (lastText == null) {
                        lastText = child;
                        continue;
                    }
                    if (lastText.getChars().isContinuedBy(child.getChars())) {
                        lastText.setChars(lastText.getChars().spliceAtEnd(child.getChars()));
                        continue;
                    }
                    if (mergedList == null) {
                        mergedList = new ArrayList();
                    }
                    mergedList.add(lastText);
                    lastText = child;
                    continue;
                }
                if (mergedList == null) {
                    mergedList = new ArrayList<Node>();
                }
                if (lastText != null) {
                    mergedList.add(lastText);
                    lastText = null;
                }
                mergedList.add(child);
            }
            if (lastText != null) {
                if (mergedList == null) {
                    this.list.clear();
                    this.list.add(lastText);
                } else {
                    mergedList.add(lastText);
                }
            }
            if (mergedList != null) {
                this.list = mergedList;
            }
        }
    }

    public List<Node> getMergedList() {
        this.mergeList();
        return this.list;
    }
}

