/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink;

import com.vladsch.flexmark.ast.LinkRefDerived;
import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public class WikiNode
extends Node
implements DoNotDecorate,
TextContainer,
LinkRefDerived {
    public static final char SEPARATOR_CHAR = '|';
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence link = BasedSequence.NULL;
    protected BasedSequence pageRef = BasedSequence.NULL;
    protected BasedSequence anchorMarker = BasedSequence.NULL;
    protected BasedSequence anchorRef = BasedSequence.NULL;
    protected BasedSequence textSeparatorMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected final boolean linkIsFirst;

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        if (this.linkIsFirst) {
            return new BasedSequence[]{this.openingMarker, this.link, this.pageRef, this.anchorMarker, this.anchorRef, this.textSeparatorMarker, this.text, this.closingMarker};
        }
        return new BasedSequence[]{this.openingMarker, this.text, this.textSeparatorMarker, this.link, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        if (this.linkIsFirst) {
            WikiNode.segmentSpanChars(out, this.openingMarker, "linkOpen");
            WikiNode.segmentSpanChars(out, this.text, "text");
            WikiNode.segmentSpanChars(out, this.textSeparatorMarker, "textSep");
            WikiNode.segmentSpanChars(out, this.link, "link");
            if (this.pageRef.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.pageRef, "pageRef");
            }
            if (this.anchorMarker.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.anchorMarker, "anchorMarker");
            }
            if (this.anchorRef.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.anchorRef, "anchorRef");
            }
            WikiNode.segmentSpanChars(out, this.closingMarker, "linkClose");
        } else {
            WikiNode.segmentSpanChars(out, this.openingMarker, "linkOpen");
            WikiNode.segmentSpanChars(out, this.link, "link");
            if (this.pageRef.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.pageRef, "pageRef");
            }
            if (this.anchorMarker.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.anchorMarker, "anchorMarker");
            }
            if (this.anchorRef.isNotNull()) {
                WikiNode.segmentSpanChars(out, this.anchorRef, "anchorRef");
            }
            WikiNode.segmentSpanChars(out, this.textSeparatorMarker, "textSep");
            WikiNode.segmentSpanChars(out, this.text, "text");
            WikiNode.segmentSpanChars(out, this.closingMarker, "linkClose");
        }
    }

    public boolean isLinkIsFirst() {
        return this.linkIsFirst;
    }

    public WikiNode(boolean linkIsFirst) {
        this.linkIsFirst = linkIsFirst;
    }

    @Override
    public boolean isTentative() {
        return false;
    }

    public WikiNode(BasedSequence chars, boolean linkIsFirst, boolean allowAnchors, boolean canEscapePipe, boolean canEscapeAnchor) {
        super(chars);
        this.linkIsFirst = linkIsFirst;
        this.setLinkChars(chars, allowAnchors, canEscapePipe, canEscapeAnchor);
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getPageRef() {
        return this.pageRef;
    }

    public void setPageRef(BasedSequence pageRef) {
        this.pageRef = pageRef;
    }

    public BasedSequence getTextSeparatorMarker() {
        return this.textSeparatorMarker;
    }

    public void setTextSeparatorMarker(BasedSequence textSeparatorMarker) {
        this.textSeparatorMarker = textSeparatorMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getAnchorMarker() {
        return this.anchorMarker;
    }

    public void setAnchorMarker(BasedSequence anchorMarker) {
        this.anchorMarker = anchorMarker;
    }

    public BasedSequence getAnchorRef() {
        return this.anchorRef;
    }

    public void setAnchorRef(BasedSequence anchorRef) {
        this.anchorRef = anchorRef;
    }

    public BasedSequence getLink() {
        return this.link;
    }

    public void setLink(BasedSequence linkChars, boolean allowAnchors, boolean canEscapeAnchor) {
        this.link = linkChars;
        if (!allowAnchors) {
            this.pageRef = linkChars;
        } else {
            int pos = -1;
            while ((pos = linkChars.indexOf('#', pos + 1)) != -1 && canEscapeAnchor && pos > 0 && linkChars.charAt(pos - 1) == '\\' && (linkChars.subSequence(0, pos).countTrailing(CharPredicate.BACKSLASH) & 1) == 1) {
            }
            if (pos < 0) {
                this.pageRef = linkChars;
            } else {
                this.pageRef = linkChars.subSequence(0, pos);
                this.anchorMarker = linkChars.subSequence(pos, pos + 1);
                this.anchorRef = (BasedSequence)linkChars.subSequence(pos + 1);
            }
        }
    }

    public void setLinkChars(BasedSequence linkChars, boolean allowAnchors, boolean canEscapePipe, boolean canEscapeAnchor) {
        BasedSequence link;
        int pos;
        int length = linkChars.length();
        int start = this instanceof WikiImage ? 3 : 2;
        this.openingMarker = linkChars.subSequence(0, start);
        this.closingMarker = linkChars.subSequence(length - 2, length);
        if (this.linkIsFirst) {
            pos = linkChars.length() - 2;
            while ((pos = linkChars.lastIndexOf('|', pos - 1)) != -1 && canEscapePipe && pos > 0 && linkChars.charAt(pos - 1) == '\\' && (linkChars.subSequence(0, pos).countTrailing(CharPredicate.BACKSLASH) & 1) == 1) {
            }
        } else {
            pos = -1;
            while ((pos = linkChars.indexOf('|', pos + 1)) != -1 && canEscapePipe && pos > 0 && linkChars.charAt(pos - 1) == '\\' && (linkChars.subSequence(0, pos).countTrailing(CharPredicate.BACKSLASH) & 1) == 1) {
            }
        }
        if (pos < 0) {
            link = linkChars.subSequence(start, length - 2);
        } else {
            this.textSeparatorMarker = linkChars.subSequence(pos, pos + 1);
            if (this.linkIsFirst) {
                link = linkChars.subSequence(start, pos);
                this.text = linkChars.subSequence(pos + 1, length - 2);
            } else {
                this.text = linkChars.subSequence(start, pos);
                link = linkChars.subSequence(pos + 1, length - 2);
            }
        }
        this.setLink(link, allowAnchors, canEscapeAnchor);
        if (this.text.isNull() && allowAnchors && !this.anchorMarker.isNull()) {
            this.text = this.pageRef;
        }
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        BasedSequence text;
        int urlType = flags & F_LINK_TEXT_TYPE;
        switch (urlType) {
            case 1: {
                text = this.getPageRef();
                break;
            }
            case 2: {
                text = this.getAnchorRef();
                break;
            }
            case 3: {
                text = this.getLink();
                break;
            }
            case 4: {
                text = BasedSequence.NULL;
                break;
            }
            default: {
                return true;
            }
        }
        if (urlType == 4) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(text);
            BasedSequence unescaped = Escaping.unescape(text, textMapper);
            out.append(unescaped);
        }
        return false;
    }
}

