/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.line;

import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.numbers.core.Precision;

public final class Segment3D
extends LineConvexSubset3D {
    private final double start;
    private final double end;

    Segment3D(Line3D line, Vector3D startPoint, Vector3D endPoint) {
        this(line, line.abscissa(startPoint), line.abscissa(endPoint));
    }

    Segment3D(Line3D line, double start, double end) {
        super(line);
        this.start = start;
        this.end = end;
    }

    public boolean isInfinite() {
        return false;
    }

    public boolean isFinite() {
        return true;
    }

    @Override
    public Vector3D getStartPoint() {
        return this.getLine().toSpace(this.start);
    }

    @Override
    public double getSubspaceStart() {
        return this.start;
    }

    @Override
    public Vector3D getEndPoint() {
        return this.getLine().toSpace(this.end);
    }

    @Override
    public double getSubspaceEnd() {
        return this.end;
    }

    public double getSize() {
        return this.end - this.start;
    }

    @Override
    public Vector3D getCentroid() {
        return this.getLine().toSpace(0.5 * (this.end - this.start) + this.start);
    }

    @Override
    public Bounds3D getBounds() {
        return Bounds3D.builder().add(this.getStartPoint()).add(this.getEndPoint()).build();
    }

    @Override
    public Segment3D transform(Transform<Vector3D> transform) {
        Vector3D t1 = (Vector3D)transform.apply((Object)this.getStartPoint());
        Vector3D t2 = (Vector3D)transform.apply((Object)this.getEndPoint());
        Line3D tLine = this.getLine().transform(transform);
        return new Segment3D(tLine, t1, t2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[startPoint= ").append(this.getStartPoint()).append(", endPoint= ").append(this.getEndPoint()).append(']');
        return sb.toString();
    }

    @Override
    boolean containsAbscissa(double abscissa) {
        Precision.DoubleEquivalence precision = this.getLine().getPrecision();
        return precision.gte(abscissa, this.start) && precision.lte(abscissa, this.end);
    }
}

