/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.util.ReverseCompoundBorder;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Graphics;
import javax.swing.border.Border;

public class NoTitleBarDisplayer
extends BasicDockableDisplayer
implements DockableDisplayer,
InvisibleTabPane,
BorderedComponent {
    private PropertyValue<TabPainter> painter;
    private TitleBarObserver observer;
    private InvisibleTab invisibleTab;
    private Border innerBorder;
    private Border outerBorder;
    private DisplayerBorder innerBorderModifier = new DisplayerBorder("in");
    private DisplayerBorder outerBorderModifier = new DisplayerBorder("out");

    public NoTitleBarDisplayer(DockStation station, Dockable dockable, DockTitle title, EclipseThemeConnector.TitleBar bar) {
        super(station);
        this.setDockable(dockable);
        this.setTitle(title);
        this.setTransparency(Transparency.TRANSPARENT);
        boolean bordered = bar == EclipseThemeConnector.TitleBar.NONE_BORDERED || bar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        boolean respectHints = bar == EclipseThemeConnector.TitleBar.NONE_HINTED || bar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.setRespectBorderHint(respectHints);
        this.setDefaultBorderHint(bordered);
        this.observer = new TitleBarObserver(station, dockable, bar){

            @Override
            protected void invalidated() {
                for (DockableDisplayerListener listener : NoTitleBarDisplayer.this.listeners()) {
                    listener.discard(NoTitleBarDisplayer.this);
                }
            }
        };
        this.painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

            @Override
            protected void valueChanged(TabPainter oldValue, TabPainter newValue) {
                NoTitleBarDisplayer.this.updateFullBorder();
                NoTitleBarDisplayer.this.updateInvisibleTab();
            }
        };
        this.updateFullBorder();
        this.updateInvisibleTab();
    }

    private boolean getBorderHint() {
        if (this.isRespectBorderHint()) {
            return this.getHints().getShowBorderHint();
        }
        return this.getDefaultBorderHint();
    }

    @Override
    public void updateFullBorder() {
        if ((this.isRespectBorderHint() || this.getDefaultBorderHint()) && this.painter != null) {
            TabPainter painter = this.painter.getValue();
            Dockable dockable = this.getDockable();
            DockController controller = this.getController();
            this.outerBorder = controller == null || painter == null || dockable == null ? null : (this.getBorderHint() ? painter.getFullBorder(this, controller, dockable) : null);
            this.updateBorder();
        }
    }

    @Override
    public void setBorder(Dockable dockable, Border border) {
        if (dockable != this.getDockable()) {
            throw new IllegalArgumentException("unknown dockable: " + dockable);
        }
        if ((this.getDefaultBorderHint() || this.isRespectBorderHint()) && this.getBorderHint()) {
            this.innerBorder = border;
            this.updateBorder();
        }
    }

    @Override
    protected Border getDefaultBorder() {
        Border innerBorder = this.innerBorderModifier.modify(this.innerBorder);
        Border outerBorder = this.outerBorderModifier.modify(this.outerBorder);
        if (innerBorder == null && outerBorder == null) {
            return null;
        }
        if (innerBorder == null) {
            return outerBorder;
        }
        if (outerBorder == null) {
            return innerBorder;
        }
        return new ReverseCompoundBorder(outerBorder, innerBorder);
    }

    protected void updateInvisibleTab() {
        TabPainter painter;
        Dockable dockable;
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if ((dockable = this.getDockable()) != null && this.painter != null && (painter = this.painter.getValue()) != null) {
            this.invisibleTab = painter.createInvisibleTab(this, dockable);
            this.invisibleTab.setController(this.getController());
        }
    }

    @Override
    public TabPlacement getDockTabPlacement() {
        DockController controller = this.getController();
        if (controller == null) {
            return null;
        }
        return controller.getProperties().get(StackDockStation.TAB_PLACEMENT);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintBorder(g);
    }

    @Override
    public Dockable getSelectedDockable() {
        return this.getDockable();
    }

    @Override
    public void setController(DockController controller) {
        DockController oldController = this.getController();
        super.setController(oldController);
        if (this.painter != null) {
            this.painter.setProperties(controller == null ? null : controller.getProperties());
        }
        if (this.observer != null) {
            this.observer.setController(controller);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(controller);
        }
        this.innerBorderModifier.setController(oldController, controller);
        this.outerBorderModifier.setController(oldController, controller);
        this.updateFullBorder();
    }

    @Override
    public void setDockable(Dockable dockable) {
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        super.setDockable(dockable);
        this.updateInvisibleTab();
    }

    @Override
    protected BasicDockableDisplayerDecorator createTabDecorator() {
        if (this.isStacked()) {
            return this.createStackedDecorator();
        }
        return this.createMinimalDecorator();
    }

    private class DisplayerBorder
    implements DisplayerDockBorder {
        private String suffix;
        private BorderModifier modifier;

        public DisplayerBorder(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return NoTitleBarDisplayer.this;
        }

        public void setController(DockController oldController, DockController newController) {
            if (oldController != null) {
                oldController.getThemeManager().remove(this);
            }
            if (newController != null) {
                String id = "dock.border.displayer.eclipse.no_title." + this.suffix;
                newController.getThemeManager().add(id, DisplayerDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            } else {
                this.set(null);
            }
        }

        @Override
        public void set(BorderModifier value) {
            if (value != this.modifier) {
                this.modifier = value;
                NoTitleBarDisplayer.this.updateBorder();
            }
        }

        public Border modify(Border border) {
            if (this.modifier == null) {
                return border;
            }
            return this.modifier.modify(border);
        }
    }
}

