/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.displayer;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.ResourceRequest;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.extension.SharedExtension;

public abstract class DisplayerRequest
extends ResourceRequest<DockableDisplayer> {
    private Dockable target;
    private DockStation parent;
    private DockTitle title;
    private DockController controller;
    private SharedExtension<DisplayerFactory> extensions;
    private DisplayerFactory defaultFactory;
    private String displayerId;

    public DisplayerRequest(DockStation parent, Dockable target, DisplayerFactory defaultFactory, String displayerId) {
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (displayerId == null) {
            throw new IllegalArgumentException("displayerId must not be null");
        }
        this.parent = parent;
        this.target = target;
        this.defaultFactory = defaultFactory;
        this.displayerId = displayerId;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            if (this.extensions != null) {
                this.extensions.unbind();
                this.extensions = null;
            }
            if (controller != null) {
                this.extensions = controller.getExtensions().share(new ExtensionName<DisplayerFactory>(DisplayerFactory.DISPLAYER_EXTENSION, DisplayerFactory.class, "name", this.displayerId));
                this.extensions.bind();
            }
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void request(DockTitle title) {
        this.title = title;
        try {
            this.request();
        }
        finally {
            this.title = null;
        }
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    @Override
    public void answer(DockableDisplayer displayer) {
        super.answer(displayer);
    }

    @Override
    protected void executeRequestList() {
        this.target.requestDisplayer(this);
        if (this.isAnswered()) {
            return;
        }
        this.parent.requestChildDisplayer(this);
        if (this.isAnswered()) {
            return;
        }
        if (this.extensions != null) {
            for (DisplayerFactory factory : this.extensions) {
                factory.request(this);
                if (!this.isAnswered()) continue;
                return;
            }
        }
        this.defaultFactory.request(this);
    }

    @Override
    protected void validate(DockableDisplayer resource) {
        if (resource == null) {
            throw new IllegalArgumentException("displayer is null");
        }
        if (resource.getDockable() != this.getTarget()) {
            throw new IllegalArgumentException("displayer.getDockable() is not target");
        }
    }
}

