/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;

public abstract class AbstractBoundaryRestriction
implements BoundaryRestriction {
    @Override
    public Rectangle check(ScreenDockWindow window) {
        Rectangle target = this.checkSize(window);
        return this.validate(window, target);
    }

    @Override
    public Rectangle check(ScreenDockWindow window, Rectangle target) {
        target = this.checkSize(window, target);
        return this.validate(window, target);
    }

    protected abstract Rectangle checkSize(ScreenDockWindow var1);

    protected abstract Rectangle checkSize(ScreenDockWindow var1, Rectangle var2);

    private Rectangle validate(ScreenDockWindow window, Rectangle target) {
        Dimension max = this.getMaximumSize(window);
        if (target == null) {
            target = window.getWindowBounds();
        }
        return new Rectangle(target.x, target.y, Math.min(max.width, target.width), Math.min(max.height, target.height));
    }

    protected Dimension getMaximumSize(ScreenDockWindow window) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int width = 0;
        int height = 0;
        for (GraphicsDevice sc : ge.getScreenDevices()) {
            Rectangle bounds = sc.getDefaultConfiguration().getBounds();
            width = Math.max(width, bounds.width);
            height = Math.max(height, bounds.height);
        }
        return new Dimension(width + 5, height + 5);
    }
}

