/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.stack.DefaultDndAutoSelectStrategyRequest;
import bibliothek.gui.dock.station.stack.DndAutoSelectStrategy;
import bibliothek.gui.dock.station.stack.StackDnDAutoSelectSupport;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.util.container.Tuple;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DnDAutoSelectSupport
extends TransferHandler
implements StackDnDAutoSelectSupport {
    private Map<JComponent, Tuple<StackDockStation, StackDockComponent>> components = new HashMap<JComponent, Tuple<StackDockStation, StackDockComponent>>();

    @Override
    public void install(StackDockStation station, StackDockComponent component) {
        Component comp = component.getComponent();
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.setTransferHandler(this);
            this.components.put(jcomp, Tuple.of(station, component));
        }
    }

    @Override
    public void uninstall(StackDockComponent component) {
        Component comp = component.getComponent();
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.setTransferHandler(null);
            this.components.remove(jcomp);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        Tuple<StackDockStation, StackDockComponent> tuple;
        if (support.isDrop() && (tuple = this.components.get(support.getComponent())) != null) {
            this.forward((StackDockStation)tuple.getA(), tuple.getB(), support);
        }
        return false;
    }

    private void forward(StackDockStation station, StackDockComponent component, TransferHandler.TransferSupport support) {
        TransferHandler.DropLocation location = support.getDropLocation();
        Point mouse = location.getDropPoint();
        int tab = component.getIndexOfTabAt(mouse);
        if (tab != -1) {
            this.forward(station, component.getDockableAt(tab), support);
        }
    }

    private void forward(StackDockStation station, Dockable dockable, TransferHandler.TransferSupport support) {
        DockController controller = station.getController();
        DndAutoSelectStrategy strategy = controller.getProperties().get(StackDockStation.DND_AUTO_SELECT_STRATEGY);
        if (strategy != null) {
            strategy.handleRequest(new DefaultDndAutoSelectStrategyRequest(station, dockable, support));
        }
    }
}

