/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.QuaternionFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.QuaternionAggregator;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.math.MathType;

public class ArrayH256
extends ScalarArray<Quaternion> {
    public static final DenseArray.Factory<Quaternion> FACTORY = new DenseArray.Factory<Quaternion>(){

        @Override
        public AggregatorSet<Quaternion> aggregator() {
            return QuaternionAggregator.getSet();
        }

        @Override
        public FunctionSet<Quaternion> function() {
            return QuaternionFunction.getSet();
        }

        @Override
        public Scalar.Factory<Quaternion> scalar() {
            return Quaternion.FACTORY;
        }

        @Override
        MathType getMathType() {
            return MathType.H256;
        }

        @Override
        PlainArray<Quaternion> makeDenseArray(long size) {
            return ArrayH256.make((int)size);
        }
    };

    public static ArrayH256 make(int size) {
        return new ArrayH256(size);
    }

    public static ArrayH256 wrap(Quaternion ... data) {
        return new ArrayH256(data);
    }

    protected ArrayH256(int size) {
        super(FACTORY, size);
    }

    protected ArrayH256(Quaternion[] data) {
        super(FACTORY, (Scalar[])data);
    }
}

