/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.ReaderWriterBuilder;
import org.ojalgo.netio.ShardedFile;
import org.ojalgo.netio.ToFileWriter;
import org.ojalgo.type.function.AutoSupplier;
import org.ojalgo.type.function.OperatorWithException;

public interface FromFileReader<T>
extends AutoSupplier<T>,
Closeable {
    public static void copy(File sourceFile, Properties destinationMap) {
        BasicLogger.debug("Path to properties file: {}", sourceFile);
        try (FileInputStream stream = new FileInputStream(sourceFile);){
            destinationMap.load(stream);
        }
        catch (IOException cause) {
            BasicLogger.error(cause, "Failed to load properties file!", new Object[0]);
        }
    }

    public static void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File[] nested = file.listFiles();
        if (nested != null && nested.length > 0) {
            for (File subfile : nested) {
                FromFileReader.delete(subfile);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException("Failed to delete " + file.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserializeObjectFromFile(File file) {
        try (ObjectInputStream ois = new ObjectInputStream(FromFileReader.input(file));){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static InputStream input(File file) {
        try {
            ToFileWriter.mkdirs(file.getParentFile());
            String name = file.getName();
            InputStream retVal = new FileInputStream(file);
            if (name.endsWith(".gz")) {
                retVal = new GZIPInputStream(retVal);
            } else if (name.endsWith(".zip")) {
                retVal = new ZipInputStream(retVal);
            }
            return retVal;
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static InputStream input(File file, OperatorWithException<InputStream> filter) {
        return filter.apply(FromFileReader.input(file));
    }

    public static Builder newBuilder(File ... file) {
        return new Builder(file);
    }

    public static Builder newBuilder(ShardedFile shards) {
        return new Builder(shards.shards());
    }

    public static <S, T> Supplier<AutoSupplier<T>> newFactory(Function<S, FromFileReader<T>> factory, Collection<? extends S> sources) {
        LinkedBlockingDeque work = new LinkedBlockingDeque(sources);
        return () -> AutoSupplier.sequenced(work, factory);
    }

    public static <S, T> Supplier<AutoSupplier<T>> newFactory(Function<S, FromFileReader<T>> factory, S ... sources) {
        LinkedBlockingDeque work = new LinkedBlockingDeque();
        Collections.addAll(work, sources);
        return () -> AutoSupplier.sequenced(work, factory);
    }

    @Override
    default public void close() throws IOException {
        try {
            AutoSupplier.super.close();
        }
        catch (Exception cause) {
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static final class Builder
    extends ReaderWriterBuilder<Builder> {
        Builder(File[] files) {
            super(files);
        }

        public <T> AutoSupplier<T> build(Function<File, ? extends FromFileReader<T>> factory) {
            AutoSupplier single;
            File[] files = this.getFiles();
            LinkedBlockingDeque queue = new LinkedBlockingDeque(this.getQueueCapacity());
            if (files.length == 1) {
                single = AutoSupplier.queued(this.getExecutor(), queue, factory.apply(files[0]));
            } else {
                LinkedBlockingDeque containers = new LinkedBlockingDeque(files.length);
                Collections.addAll(containers, files);
                AutoSupplier[] readers = new AutoSupplier[this.getParallelism()];
                for (int i = 0; i < readers.length; ++i) {
                    readers[i] = AutoSupplier.sequenced(containers, factory);
                }
                single = AutoSupplier.queued(this.getExecutor(), queue, readers);
            }
            if (this.isStatisticsCollector()) {
                return AutoSupplier.managed(this.getStatisticsCollector(), single);
            }
            return single;
        }
    }
}

