/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public final class PngChunkScal
extends PngChunk {
    private final double unitsPerPixelXAxis;
    private final double unitsPerPixelYAxis;
    private final int unitSpecifier;

    public PngChunkScal(int length, int chunkType, int crc, byte[] bytes) throws ImagingException {
        super(length, chunkType, crc, bytes);
        this.unitSpecifier = bytes[0];
        if (this.getUnitSpecifier() != 1 && this.getUnitSpecifier() != 2) {
            throw new ImagingException("PNG sCAL invalid unit specifier: " + this.getUnitSpecifier());
        }
        int separator = BinaryFunctions.indexOf0(bytes, "PNG sCAL x and y axis value separator not found.");
        boolean xIndex = true;
        String xStr = new String(bytes, 1, separator - 1, StandardCharsets.ISO_8859_1);
        this.unitsPerPixelXAxis = this.toDouble(xStr);
        int yIndex = separator + 1;
        if (yIndex >= length) {
            throw new ImagingException("PNG sCAL chunk missing the y axis value.");
        }
        String yStr = new String(bytes, yIndex, length - yIndex, StandardCharsets.ISO_8859_1);
        this.unitsPerPixelYAxis = this.toDouble(yStr);
    }

    public int getUnitSpecifier() {
        return this.unitSpecifier;
    }

    public double getUnitsPerPixelXAxis() {
        return this.unitsPerPixelXAxis;
    }

    public double getUnitsPerPixelYAxis() {
        return this.unitsPerPixelYAxis;
    }

    private double toDouble(String str) throws ImagingException {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new ImagingException("PNG sCAL error reading axis value - " + str);
        }
    }
}

