/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

final class ExtendedPrecision {
    static final double SQRT2PI = 2.5066282746310007;
    static final double SQRT2PI_R = -1.8328579980459167E-16;
    private static final double MULTIPLIER = 1.34217729E8;
    private static final double BIG = 3.273390607896142E150;
    private static final double SMALL = 3.054936363499605E-151;
    private static final double SCALE_UP = 4.149515568880993E180;
    private static final double SCALE_DOWN = 2.409919865102884E-181;
    private static final double SQRT2PI_H = ExtendedPrecision.highPartUnscaled(2.5066282746310007);
    private static final double SQRT2PI_L = 2.5066282746310007 - SQRT2PI_H;
    private static final int EXP_M_HALF_XX_MIN_VALUE = 2;
    private static final int EXP_M_HALF_XX_MAX_VALUE = 1491;

    private ExtendedPrecision() {
    }

    static double xsqrt2pi(double x) {
        if (x > 3.273390607896142E150) {
            if (x == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return ExtendedPrecision.computeXsqrt2pi(x * 2.409919865102884E-181) * 4.149515568880993E180;
        }
        if (x < 3.054936363499605E-151) {
            return ExtendedPrecision.computeXsqrt2pi(x * 4.149515568880993E180) * 2.409919865102884E-181;
        }
        return ExtendedPrecision.computeXsqrt2pi(x);
    }

    private static double computeXsqrt2pi(double a) {
        double ha = ExtendedPrecision.highPartUnscaled(a);
        double la = a - ha;
        double x = a * 2.5066282746310007;
        double xx = ExtendedPrecision.productLow(ha, la, SQRT2PI_H, SQRT2PI_L, x);
        return a * -1.8328579980459167E-16 + xx + x;
    }

    static double sqrt2xx(double x) {
        if (x > 3.273390607896142E150) {
            if (x == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return ExtendedPrecision.computeSqrt2aa(x * 2.409919865102884E-181) * 4.149515568880993E180;
        }
        if (x < 3.054936363499605E-151) {
            return ExtendedPrecision.computeSqrt2aa(x * 4.149515568880993E180) * 2.409919865102884E-181;
        }
        return ExtendedPrecision.computeSqrt2aa(x);
    }

    private static double computeSqrt2aa(double a) {
        double ha = ExtendedPrecision.highPartUnscaled(a);
        double la = a - ha;
        double x = 2.0 * a * a;
        double xx = ExtendedPrecision.productLow(ha, la, 2.0 * ha, 2.0 * la, x);
        double c = Math.sqrt(x);
        if (xx == 0.0) {
            return c;
        }
        double hc = ExtendedPrecision.highPartUnscaled(c);
        double lc = c - hc;
        double u = c * c;
        double uu = ExtendedPrecision.productLow(hc, lc, hc, lc, u);
        double cc = (x - u - uu + xx) * 0.5 / c;
        return c + cc;
    }

    static double expmhxx(double x) {
        double z = x * x;
        if (z <= 2.0) {
            return Math.exp(-0.5 * z);
        }
        if (z >= 1491.0) {
            return 0.0;
        }
        double hx = ExtendedPrecision.highPartUnscaled(x);
        double lx = x - hx;
        double zz = ExtendedPrecision.squareLow(hx, lx, z);
        return ExtendedPrecision.expxx(-0.5 * z, -0.5 * zz);
    }

    private static double expxx(double a, double b) {
        double ea = Math.exp(a);
        return ea * b + ea;
    }

    private static double highPartUnscaled(double value) {
        double c = 1.34217729E8 * value;
        return c - (c - value);
    }

    private static double productLow(double hx, double lx, double hy, double ly, double xy) {
        return lx * ly - (xy - hx * hy - lx * hy - hx * ly);
    }

    private static double squareLow(double hx, double lx, double xx) {
        return lx * lx - (xx - hx * hx - 2.0 * lx * hx);
    }
}

