/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.data.domain.finance.FinanceUtils;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public class PortfolioContext
implements FinancePortfolio.Context {
    private final Primitive64Matrix myAssetReturns;
    private Primitive64Matrix myAssetVolatilities = null;
    private Primitive64Matrix myCorrelations = null;
    private Primitive64Matrix myCovariances = null;

    public PortfolioContext(Access1D<?> assetReturns, Access1D<?> assetVolatilities, Access2D<?> correlations) {
        this.myAssetReturns = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetReturns});
        this.myAssetVolatilities = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetVolatilities});
        this.myCorrelations = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.copy((Access2D)correlations);
    }

    public PortfolioContext(Access1D<?> assetReturns, Access2D<?> covariances) {
        this.myAssetReturns = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new Access1D[]{assetReturns});
        this.myCovariances = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.copy((Access2D)covariances);
    }

    private PortfolioContext() {
        this.myAssetReturns = null;
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        return ((Primitive64Matrix)((Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.rows(new List[]{weightsPortfolio.getWeights()})).multiply(this.getAssetReturns())).doubleValue(0L);
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        Primitive64Matrix tmpWeights = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{weightsPortfolio.getWeights()});
        return ((Primitive64Matrix)((Primitive64Matrix)tmpWeights.transpose()).multiply((Primitive64Matrix)this.getCovariances().multiply(tmpWeights))).doubleValue(0L);
    }

    @Override
    public Primitive64Matrix getAssetReturns() {
        return this.myAssetReturns;
    }

    @Override
    public Primitive64Matrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances);
        }
        return this.myAssetVolatilities;
    }

    @Override
    public Primitive64Matrix getCorrelations() {
        if (this.myCorrelations == null) {
            this.myCorrelations = FinanceUtils.toCorrelations(this.myCovariances, false);
        }
        return this.myCorrelations;
    }

    @Override
    public Primitive64Matrix getCovariances() {
        if (this.myCovariances == null) {
            this.myCovariances = FinanceUtils.toCovariances(this.myAssetVolatilities, this.myCorrelations);
        }
        return this.myCovariances;
    }

    @Override
    public int size() {
        return (int)this.myAssetReturns.count();
    }
}

