/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.InputStream;
import java.net.http.HttpResponse;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.netio.ServiceClient;
import org.ojalgo.type.CalendarDateUnit;

public final class AlphaVantageFetcher
implements DataFetcher {
    private final ServiceClient.Request myRequest;
    private final CalendarDateUnit myResolution;
    private final String mySymbol;

    public AlphaVantageFetcher(String symbol, CalendarDateUnit resolution, String apiKey, boolean fullOutputSize) {
        this.mySymbol = symbol;
        this.myResolution = resolution;
        this.myRequest = ServiceClient.newRequest().host("www.alphavantage.co").path("/query");
        switch (resolution) {
            case MONTH: {
                this.myRequest.query("function", "TIME_SERIES_MONTHLY_ADJUSTED");
                break;
            }
            case WEEK: {
                this.myRequest.query("function", "TIME_SERIES_WEEKLY_ADJUSTED");
                break;
            }
            default: {
                this.myRequest.query("function", "TIME_SERIES_DAILY_ADJUSTED");
            }
        }
        this.myRequest.query("symbol", symbol);
        this.myRequest.query("apikey", apiKey);
        this.myRequest.query("datatype", "csv");
        if (fullOutputSize && resolution == CalendarDateUnit.DAY && !"demo".equals(apiKey)) {
            this.myRequest.query("outputsize", "full");
        }
    }

    @Override
    public InputStream getInputStream() {
        ServiceClient.Response<InputStream> response = this.myRequest.send(HttpResponse.BodyHandlers.ofInputStream());
        if (response.isResponseOK()) {
            return response.getBody();
        }
        return InputStream.nullInputStream();
    }

    @Override
    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    @Override
    public String getSymbol() {
        return this.mySymbol;
    }
}

