/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Distribution1D;
import org.ojalgo.random.Random1D;
import org.ojalgo.structure.Access2D;

abstract class AbstractDistribution1D
implements Distribution1D {
    private final Random1D myRandom;

    protected AbstractDistribution1D(Access2D<?> correlations) {
        this.myRandom = new Random1D(correlations);
    }

    @Override
    public Array1D<Double> getStandardDeviation() {
        Array1D<Double> tmpVar = this.getVariance();
        int tmpLength = tmpVar.size();
        Array1D retVal = (Array1D)Array1D.R064.make(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            retVal.set((long)i, PrimitiveMath.SQRT.invoke(tmpVar.doubleValue(i)));
        }
        return retVal;
    }

    @Override
    public Array1D<Double> getVariance() {
        Array1D<Double> tmpStdDev = this.getStandardDeviation();
        int tmpLength = tmpStdDev.size();
        Array1D retVal = (Array1D)Array1D.R064.make(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            double tmpVal = tmpStdDev.doubleValue(i);
            retVal.set((long)i, tmpVal * tmpVal);
        }
        return retVal;
    }

    protected final Random1D random() {
        return this.myRandom;
    }
}

