/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.LongToNumberMap;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.ColourData;
import org.ojalgo.type.TypeUtils;

final class MappedIndexSeries<K extends Comparable<? super K>, N extends Comparable<N>>
extends AbstractMap<K, N>
implements BasicSeries.NaturallySequenced<K, N> {
    static final Structure1D.IndexMapper<Double> MAPPER = new Structure1D.IndexMapper<Double>(){

        @Override
        public long toIndex(Double key) {
            return MappedIndexSeries.toIndex(key);
        }

        @Override
        public Double toKey(long index) {
            return MappedIndexSeries.toKey(index);
        }
    };
    private final BinaryFunction<N> myAccumulator;
    private ColourData myColour = null;
    private final LongToNumberMap<N> myDelegate;
    private final Structure1D.IndexMapper<K> myMapper;
    private String myName = null;

    static long toIndex(double key) {
        if (key >= PrimitiveMath.ZERO) {
            return Double.doubleToLongBits(key);
        }
        throw new IllegalArgumentException("Negative keys not supported!");
    }

    static double toKey(long index) {
        return Double.longBitsToDouble(index);
    }

    MappedIndexSeries(DenseArray.Factory<N> denseArrayFactory, Structure1D.IndexMapper<K> indexMapper, BinaryFunction<N> accumulator) {
        this.myDelegate = LongToNumberMap.factory(denseArrayFactory).make();
        this.myMapper = indexMapper;
        this.myAccumulator = accumulator;
    }

    MappedIndexSeries(Structure1D.IndexMapper<K> indexMapper, LongToNumberMap<N> delegate, BinaryFunction<N> accumulator) {
        this.myDelegate = delegate;
        this.myMapper = indexMapper;
        this.myAccumulator = accumulator;
    }

    @Override
    public PrimitiveSeries asPrimitive() {
        return PrimitiveSeries.wrap(this.myDelegate.values());
    }

    @Override
    public MappedIndexSeries<K, N> colour(ColourData colour) {
        this.setColour(colour);
        return this;
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public void complete() {
        this.complete(key -> this.myMapper.next(key));
    }

    @Override
    public double doubleValue(K key) {
        return this.myDelegate.doubleValue(this.myMapper.toIndex(key));
    }

    @Override
    public Set<Map.Entry<K, N>> entrySet() {
        return new AbstractSet<Map.Entry<K, N>>(){

            @Override
            public Iterator<Map.Entry<K, N>> iterator() {
                final Iterator tmpDelegateIterator = MappedIndexSeries.this.myDelegate.entrySet().iterator();
                return new Iterator<Map.Entry<K, N>>(){

                    @Override
                    public boolean hasNext() {
                        return tmpDelegateIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, N> next() {
                        final Map.Entry tmpDelegateNext = (Map.Entry)tmpDelegateIterator.next();
                        return new Map.Entry<K, N>(){

                            @Override
                            public K getKey() {
                                return (Comparable)MappedIndexSeries.this.myMapper.toKey((Long)tmpDelegateNext.getKey());
                            }

                            @Override
                            public N getValue() {
                                return (Comparable)tmpDelegateNext.getValue();
                            }

                            @Override
                            public N setValue(N value) {
                                return (Comparable)tmpDelegateNext.setValue(value);
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return MappedIndexSeries.this.myDelegate.size();
            }
        };
    }

    @Override
    public K firstKey() {
        return (K)((Comparable)this.myMapper.toKey(this.myDelegate.firstKey()));
    }

    @Override
    public N firstValue() {
        return this.get((K)this.firstKey());
    }

    @Override
    public N get(K key) {
        return this.myDelegate.get(this.myMapper.toIndex(key));
    }

    @Override
    public N get(Object key) {
        if (key instanceof Comparable) {
            return this.myDelegate.get(this.myMapper.toIndex((Comparable)key));
        }
        return null;
    }

    @Override
    public ColourData getColour() {
        if (this.myColour == null) {
            this.myColour = ColourData.random();
        }
        return this.myColour;
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            this.myName = UUID.randomUUID().toString();
        }
        return this.myName;
    }

    @Override
    public MappedIndexSeries<K, N> headMap(K toKey) {
        return this.subMap((K)this.firstKey(), toKey);
    }

    @Override
    public K lastKey() {
        return (K)((Comparable)this.myMapper.toKey(this.myDelegate.lastKey()));
    }

    @Override
    public N lastValue() {
        return this.get((K)this.lastKey());
    }

    public Structure1D.IndexMapper<K> mapper() {
        return this.myMapper;
    }

    @Override
    public MappedIndexSeries<K, N> name(String name) {
        this.setName(name);
        return this;
    }

    @Override
    public K nextKey() {
        return (K)((Comparable)this.myMapper.toKey(this.myDelegate.lastKey() + 1L));
    }

    @Override
    public double put(K key, double value) {
        long index = this.myMapper.toIndex(key);
        if (this.myAccumulator != null) {
            return this.myDelegate.mix(index, (BinaryFunction<double>)this.myAccumulator, value);
        }
        return this.myDelegate.put(index, value);
    }

    @Override
    public N put(K key, N value) {
        long index = this.myMapper.toIndex(key);
        if (this.myAccumulator != null) {
            return this.myDelegate.mix(index, this.myAccumulator, value);
        }
        return this.myDelegate.put(index, value);
    }

    @Override
    public BasicSeries<K, N> resample(UnaryOperator<K> keyTranslator) {
        MappedIndexSeries<Comparable, Comparable> retVal = new MappedIndexSeries<Comparable, Comparable>(this.myMapper, this.newDelegateInstance(), this.getAccumulator());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        for (Map.Entry<K, N> entry : this.entrySet()) {
            Comparable key = (Comparable)keyTranslator.apply((Comparable)entry.getKey());
            Comparable value = (Comparable)entry.getValue();
            retVal.put(key, value);
        }
        return retVal;
    }

    @Override
    public void setColour(ColourData colour) {
        this.myColour = colour;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public K step(K key) {
        return (K)((Comparable)this.myMapper.next(key));
    }

    @Override
    public MappedIndexSeries<K, N> subMap(K fromKey, K toKey) {
        long fromIndex = this.myMapper.toIndex(fromKey);
        long toIndex = this.myMapper.toIndex(toKey);
        LongToNumberMap<N> delegateSubMap = this.myDelegate.subMap(fromIndex, toIndex);
        return new MappedIndexSeries<K, N>(this.myMapper, delegateSubMap, this.myAccumulator);
    }

    @Override
    public MappedIndexSeries<K, N> tailMap(K fromKey) {
        return this.subMap(fromKey, this.nextKey());
    }

    @Override
    public String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.myName != null) {
            retVal.append(this.myName);
            retVal.append('\u00a0');
        }
        if (this.myColour != null) {
            retVal.append(TypeUtils.toHexString(this.myColour.getRGB()));
            retVal.append('\u00a0');
        }
        if (this.size() <= 30) {
            retVal.append(super.toString());
        } else {
            retVal.append("First:");
            retVal.append(this.firstKey());
            retVal.append('=');
            retVal.append(this.firstValue());
            retVal.append('\u00a0');
            retVal.append("Last:");
            retVal.append(this.lastKey());
            retVal.append('=');
            retVal.append(this.lastValue());
            retVal.append('\u00a0');
            retVal.append("Size:");
            retVal.append(this.size());
        }
        return retVal.toString();
    }

    private LongToNumberMap<N> newDelegateInstance() {
        return this.myDelegate.headMap(Long.MIN_VALUE);
    }

    BinaryFunction<N> getAccumulator() {
        return this.myAccumulator;
    }
}

