/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;

public class RoundButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation;
    private BasicButtonModel model;
    private AbstractDockColor[] colors;
    private boolean paintFocusBorder = true;
    private MiniButtonContent content;

    public RoundButton(BasicTrigger trigger, BasicResourceInitializer initializer, Dockable dockable, DockAction action) {
        this.setFocusable(true);
        this.content = this.createButtonContent();
        this.setLayout(null);
        this.add(this.content);
        this.animation = new BubbleColorAnimation(){

            @Override
            protected void pulse() {
                super.pulse();
                RoundButton.this.content.setLabelForeground(RoundButton.this.animation.getColor("text"));
            }
        };
        this.colors = this.createColors(dockable, action);
        this.model = new BasicButtonModel(this, trigger, initializer){

            @Override
            public void changed() {
                RoundButton.this.updateColors();
                RoundButton.this.repaint();
            }
        };
        this.model.addListener(new BasicButtonModelAdapter(){

            @Override
            public void mousePressed(BasicButtonModel model, boolean mousePressed) {
                if (mousePressed) {
                    RoundButton.this.requestFocusInWindow();
                }
            }
        });
        this.content.setModel(this.model);
        this.updateColors();
        this.animation.addTask(new Runnable(){

            @Override
            public void run() {
                RoundButton.this.repaint();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RoundButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                RoundButton.this.repaint();
            }
        });
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    protected AbstractDockColor[] createColors(Dockable dockable, DockAction action) {
        return new AbstractDockColor[]{this.createColor("action.button", dockable, action, Color.WHITE), this.createColor("action.button.enabled", dockable, action, Color.LIGHT_GRAY), this.createColor("action.button.selected", dockable, action, Color.YELLOW), this.createColor("action.button.selected.enabled", dockable, action, Color.ORANGE), this.createColor("action.button.mouse.enabled", dockable, action, Color.RED), this.createColor("action.button.mouse.selected.enabled", dockable, action, new Color(128, 0, 0)), this.createColor("action.button.pressed.enabled", dockable, action, Color.BLUE), this.createColor("action.button.pressed.selected.enabled", dockable, action, Color.MAGENTA), this.createColor("action.button.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.selected.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.selected.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.mouse.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.mouse.selected.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.pressed.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.pressed.selected.enabled.focus", dockable, action, Color.DARK_GRAY), this.createColor("action.button.text", dockable, action, null), this.createColor("action.button.text.enabled", dockable, action, null), this.createColor("action.button.text.selected", dockable, action, null), this.createColor("action.button.text.selected.enabled", dockable, action, null), this.createColor("action.button.text.mouse.enabled", dockable, action, null), this.createColor("action.button.text.mouse.selected.enabled", dockable, action, null), this.createColor("action.button.text.pressed.enabled", dockable, action, null), this.createColor("action.button.text.pressed.selected.enabled", dockable, action, null)};
    }

    protected AbstractDockColor createColor(String key, Dockable dockable, DockAction action, Color backup) {
        return new RoundActionColor(key, dockable, action, backup);
    }

    protected BubbleColorAnimation getAnimation() {
        return this.animation;
    }

    public void setPaintFocusBorder(boolean paintFocusBorder) {
        this.paintFocusBorder = paintFocusBorder;
    }

    public boolean isPaintFocusBorder() {
        return this.paintFocusBorder;
    }

    @Override
    public void setController(DockController controller) {
        for (AbstractDockColor color : this.colors) {
            color.connect(controller);
        }
        this.animation.kick();
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    @Override
    public boolean contains(int x, int y) {
        double dy;
        double dx;
        double delta;
        double h;
        if (!super.contains(x, y)) {
            return false;
        }
        double w = this.getWidth();
        if (w > (h = (double)this.getHeight())) {
            delta = h / w;
            dx = x;
            dy = delta * (double)y;
            h = w;
        } else {
            delta = w / h;
            dx = delta * (double)x;
            dy = y;
            w = h;
        }
        double dist = (dx -= w / 2.0) * dx + (dy -= h / 2.0) * dy;
        return dist <= w * w / 4.0;
    }

    protected MiniButtonContent getContent() {
        return this.content;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferred = this.content.getPreferredSize();
        return new Dimension((int)((double)preferred.width * 1.5), (int)((double)preferred.height * 1.5));
    }

    @Override
    public void doLayout() {
        Dimension size = this.content.getPreferredSize();
        int dw = this.getWidth() - size.width;
        int dh = this.getHeight() - size.height;
        dw = Math.max(0, dw);
        dh = Math.max(0, dh);
        this.content.setBounds(dw / 2, dh / 2, this.getWidth() - dw, this.getHeight() - dh);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BackgroundPaint paint = this.model.getBackground();
        BackgroundComponent component = this.model.getBackgroundComponent();
        if (paint == null) {
            this.doPaintBackground(g2);
            this.doPaintForeground(g2);
        } else {
            AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

                @Override
                protected void foreground(Graphics g) {
                    RoundButton.this.doPaintForeground(g);
                }

                @Override
                protected void background(Graphics g) {
                    RoundButton.this.doPaintBackground(g);
                }

                @Override
                protected void border(Graphics g) {
                }

                @Override
                protected void children(Graphics g) {
                }

                @Override
                protected void overlay(Graphics g) {
                }

                @Override
                public Transparency getTransparency() {
                    return Transparency.DEFAULT;
                }
            };
            paintable.paint(g2);
        }
        g2.dispose();
    }

    protected void doPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.animation.getColor("button"));
        g2.fillOval(0, 0, this.getWidth(), this.getHeight());
    }

    protected void doPaintForeground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.paintChildren(g);
        if (this.paintFocusBorder && this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(this.animation.getColor("focus"));
            g2.drawOval(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g2.setStroke(stroke);
        }
    }

    protected void updateColors() {
        String postfix = "";
        boolean mousePressed = this.model.isMousePressed();
        boolean mouseEntered = this.model.isMouseInside();
        boolean selected = this.model.isSelected();
        boolean enabled = this.model.isEnabled();
        if (enabled && mousePressed) {
            postfix = ".pressed";
        }
        if (enabled && mouseEntered && !mousePressed) {
            postfix = ".mouse";
        }
        if (selected) {
            postfix = postfix + ".selected";
        }
        if (enabled) {
            postfix = postfix + ".enabled";
        }
        String key = "action.button.text" + postfix;
        for (AbstractDockColor color : this.colors) {
            if (!key.equals(color.getId())) continue;
            this.animation.putColor("text", (Color)color.value());
            break;
        }
        key = "action.button" + postfix;
        for (AbstractDockColor color : this.colors) {
            if (!key.equals(color.getId())) continue;
            this.animation.putColor("button", (Color)color.value());
            break;
        }
        key = key + ".focus";
        for (AbstractDockColor color : this.colors) {
            if (!key.equals(color.getId())) continue;
            this.animation.putColor("focus", (Color)color.value());
            break;
        }
    }

    protected void animate(String key, String color) {
        for (AbstractDockColor value : this.colors) {
            if (!value.getId().equals(color)) continue;
            this.animation.putColor(key, value.color());
            return;
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String id, Dockable dockable, DockAction action, Color backup) {
            super(id, dockable, action, backup);
        }

        @Override
        protected void changed(Color oldColor, Color newColor) {
            RoundButton.this.updateColors();
        }
    }
}

