/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.ModifierMask;

public abstract class AcceptanceDockRelocatorMode
implements DockRelocatorMode,
DockAcceptance {
    private boolean active;
    private ModifierMask mask;

    public AcceptanceDockRelocatorMode(int onmask, int offmask) {
        this.mask = new ModifierMask(onmask, offmask);
    }

    public AcceptanceDockRelocatorMode(ModifierMask mask) {
        if (mask == null) {
            throw new IllegalArgumentException("mask must not be null");
        }
        this.mask = mask;
    }

    public void setMask(ModifierMask mask) {
        if (mask == null) {
            throw new IllegalArgumentException("mask must not be null");
        }
        this.mask = mask;
    }

    public ModifierMask getMask() {
        return this.mask;
    }

    @Override
    public void setActive(DockController controller, boolean active) {
        if (this.active != active) {
            if (active) {
                controller.addAcceptance(this);
            } else {
                controller.removeAcceptance(this);
            }
            this.active = active;
        }
    }

    @Override
    public boolean shouldBeActive(DockController controller, int modifiers) {
        return this.mask.matches(modifiers);
    }
}

