/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockUI;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.DefaultFlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.flap.FlapWindowFactory;
import bibliothek.gui.dock.station.flap.JInternalDialog;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;

public class DefaultFlapWindowFactory
implements FlapWindowFactory {
    @Override
    public FlapWindow create(FlapDockStation station, ButtonPane buttonPane) {
        Container parent = null;
        JDesktopPane desktop = this.getDesktopPaneOf(station);
        if (desktop != null) {
            parent = new JInternalDialog(desktop, station){

                @Override
                protected JDesktopPane getDesktopPaneOf(FlapDockStation station) {
                    return DefaultFlapWindowFactory.this.getDesktopPaneOf(station);
                }
            };
        } else {
            Window owner = SwingUtilities.getWindowAncestor(station.getComponent());
            if (owner instanceof Dialog) {
                parent = new DefaultFlapWindow.DialogParent((Dialog)owner, station);
            } else if (owner instanceof Frame) {
                parent = new DefaultFlapWindow.DialogParent((Frame)owner, station);
            } else {
                return null;
            }
        }
        return new DefaultFlapWindow(station, buttonPane, (DefaultFlapWindow.Parent)((Object)parent));
    }

    @Override
    public void install(FlapDockStation station) {
    }

    @Override
    public boolean isValid(FlapWindow window, FlapDockStation station) {
        DefaultFlapWindow defaultWindow = (DefaultFlapWindow)window;
        return defaultWindow.isWindowValid();
    }

    @Override
    public void uninstall(FlapDockStation station) {
    }

    protected JDesktopPane getDesktopPaneOf(FlapDockStation station) {
        return DockUI.getDesktopPane(station.getComponent());
    }
}

