/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.ui.JCheckBoxList;
import org.meteothink.trajstat.Main;

public class FrmConvertToLine
extends JDialog {
    private IApplication app;
    private JCheckBoxList checkBoxList_Data;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JButton jButton_SelAll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_PointInterval;

    public FrmConvertToLine(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        DefaultListModel<CheckBoxListEntry> listModel = new DefaultListModel<CheckBoxListEntry>();
        for (LayerNode lNode : gNode.getLayers()) {
            listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
        }
        this.checkBoxList_Data.setModel(listModel);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.checkBoxList_Data = new JCheckBoxList();
        this.jLabel1 = new JLabel();
        this.jButton_SelAll = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextField_PointInterval = new JTextField();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Convert to line data file");
        this.checkBoxList_Data.setModel((ListModel)new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView((Component)this.checkBoxList_Data);
        this.jLabel1.setText("Trajectory layers:");
        this.jButton_SelAll.setText("Select All");
        this.jButton_SelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmConvertToLine.this.jButton_SelAllActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Point interval:");
        this.jTextField_PointInterval.setText("1");
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmConvertToLine.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmConvertToLine.this.jButton_CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_SelAll, -2, 140, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_PointInterval, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 74, -2).addGap(18, 18, 18).addComponent(this.jButton_Cancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_SelAll).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 224, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField_PointInterval, -2, -1, -2).addComponent(this.jButton_OK).addComponent(this.jButton_Cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_SelAllActionPerformed(ActionEvent evt) {
        DefaultListModel listModel = (DefaultListModel)this.checkBoxList_Data.getModel();
        if (this.jButton_SelAll.getText().equals("Select All")) {
            for (int i = 0; i < listModel.getSize(); ++i) {
                ((CheckBoxListEntry)listModel.get(i)).setSelected(true);
            }
            this.jButton_SelAll.setText("Unselect All");
        } else {
            for (int i = 0; i < listModel.getSize(); ++i) {
                ((CheckBoxListEntry)listModel.get(i)).setSelected(false);
            }
            this.jButton_SelAll.setText("Select All");
        }
        this.checkBoxList_Data.repaint();
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"lcd"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Line Data File (*.lcd)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog((JFrame)this.app)) {
            File file = aDlg.getSelectedFile();
            String lcdfn = "";
            try {
                lcdfn = file.getCanonicalPath();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            if (!lcdfn.substring(lcdfn.length() - extent.length()).equals(extent)) {
                lcdfn = lcdfn + "." + extent;
            }
            this.convertToLineFile(lcdfn);
        }
        this.dispose();
    }

    private void convertToLineFile(final String outFile) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                int aInterval = Integer.parseInt(FrmConvertToLine.this.jTextField_PointInterval.getText());
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                DefaultListModel listModel = (DefaultListModel)FrmConvertToLine.this.checkBoxList_Data.getModel();
                for (i = 0; i < listModel.getSize(); ++i) {
                    if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                    layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
                }
                if (layers.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "No Trajectory layer was selected!");
                    return "";
                }
                FrmConvertToLine.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmConvertToLine.this.app.getProgressBar().setVisible(true);
                FrmConvertToLine.this.app.getProgressBar().setValue(0);
                FrmConvertToLine.this.app.getProgressBarLabel().setVisible(true);
                FrmConvertToLine.this.app.getProgressBarLabel().setText("...");
                int sNum = 0;
                BufferedWriter sw = new BufferedWriter(new FileWriter(new File(outFile)));
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
                for (VectorLayer layer : layers) {
                    FrmConvertToLine.this.app.getProgressBarLabel().setText(layer.getLayerName());
                    sNum = layer.getShapeNum();
                    for (i = 0; i < sNum; ++i) {
                        LocalDateTime aDate = (LocalDateTime)layer.getCellValue("Date", i);
                        int hour = Integer.parseInt(layer.getCellValue("Hour", i).toString());
                        aDate = aDate.withHour(hour);
                        String aLine = format.format(aDate);
                        String height = layer.getCellValue("Height", i).toString();
                        aLine = aLine + "," + height;
                        PolylineZShape aPLZ = (PolylineZShape)layer.getShapes().get(i);
                        for (int j = 0; j < aPLZ.getPointNum(); ++j) {
                            if (j % aInterval != 0) continue;
                            PointZ aPoint = (PointZ)aPLZ.getPoints().get(j);
                            aLine = aLine + "," + String.format("%.2f", aPoint.Y) + "," + String.format("%.2f", aPoint.X) + "," + String.format("%.2f", aPoint.Z);
                        }
                        sw.write(aLine);
                        sw.newLine();
                        FrmConvertToLine.this.app.getProgressBar().setValue((int)((double)(i + 1) / (double)sNum * 100.0));
                    }
                }
                sw.close();
                return "";
            }

            @Override
            protected void done() {
                FrmConvertToLine.this.app.getProgressBar().setVisible(false);
                FrmConvertToLine.this.app.getProgressBarLabel().setVisible(false);
                FrmConvertToLine.this.setCursor(null);
            }
        };
        worker.execute();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmConvertToLine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmConvertToLine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmConvertToLine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmConvertToLine.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmConvertToLine dialog = new FrmConvertToLine((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

