/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.image.ndimage;

import java.util.ArrayList;
import org.meteoinfo.image.ndimage.ExtendMode;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class MaximumFilter {
    int size = 3;
    ExtendMode mode;
    double cValue = 0.0;

    public MaximumFilter(int size, ExtendMode mode) {
        this.size = size;
        this.mode = mode;
    }

    public ExtendMode getMode() {
        return this.mode;
    }

    public void setMode(ExtendMode value) {
        this.mode = value;
    }

    public double getCValue() {
        return this.cValue;
    }

    public void setCValue(double value) {
        this.cValue = value;
    }

    private ArrayList<Double> maximum(ArrayList<Double> a) {
        int origin = this.size / 2;
        int n = a.size();
        ArrayList<Double> r = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double v = -1.7976931348623157E308;
            for (int j = 0; j < this.size; ++j) {
                int idx = i - origin + j;
                v = Math.max(this.mode.getValue(a, idx, origin, this.cValue), v);
            }
            r.add(v);
        }
        return r;
    }

    private Array maximum(Array a, int axis) throws InvalidRangeException {
        int origin = this.size / 2;
        int n = (int)a.getSize();
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        if (a.getRank() == 1) {
            ArrayList<Double> dList = new ArrayList<Double>();
            IndexIterator iter = a.getIndexIterator();
            while (iter.hasNext()) {
                dList.add(iter.getDoubleNext());
            }
            ArrayList<Double> rList = this.maximum(dList);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setDouble(i, rList.get(i).doubleValue());
                ++i;
            }
        } else {
            Index index = a.getIndex();
            int[] shape = a.getShape();
            if (axis == -1) {
                axis = n - 1;
            }
            int nn = shape[axis];
            Index indexr = r.getIndex();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < n; ++i) {
                if (i == axis) {
                    ranges.add(new Range(0, 0, 1));
                    continue;
                }
                ranges.add(new Range(0, shape[i] - 1, 1));
            }
            IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
            while (rii.hasNext()) {
                rii.next();
                int[] current = rii.getCurrentCounter();
                ranges = new ArrayList();
                for (int j = 0; j < n; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        continue;
                    }
                    ranges.add(new Range(current[j], current[j], 1));
                }
                ArrayList<Double> stlist = new ArrayList<Double>();
                IndexIterator ii = a.getRangeIterator(ranges);
                while (ii.hasNext()) {
                    double v = ii.getDoubleNext();
                    stlist.add(v);
                }
                ArrayList<Double> rList = this.maximum(stlist);
                for (int j = 0; j < nn; ++j) {
                    indexr.set(current);
                    r.setObject(indexr, (Object)rList.get(j));
                    current[axis] = current[axis] + 1;
                }
            }
        }
        return r;
    }

    public Array filter(Array data) throws InvalidRangeException {
        int ndim = data.getRank();
        int[] shape = data.getShape();
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        Index rindex = r.getIndex();
        int[] rcurrent = new int[ndim];
        for (int axis = 0; axis < ndim; ++axis) {
            int[] nshape = new int[ndim - 1];
            for (int i = 0; i < ndim; ++i) {
                if (i < axis) {
                    nshape[i] = shape[i];
                    continue;
                }
                if (i <= axis) continue;
                nshape[i - 1] = shape[i];
            }
            Index index = Index.factory((int[])nshape);
            int i = 0;
            while ((long)i < index.getSize()) {
                int[] current = index.getCurrentCounter();
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int j = 0; j < ndim; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        rcurrent[j] = 0;
                        continue;
                    }
                    int idx = j;
                    if (idx > axis) {
                        --idx;
                    }
                    ranges.add(new Range(current[idx], current[idx], 1));
                    rcurrent[j] = current[idx];
                }
                Array temp = data.section(ranges);
                temp = this.maximum(temp, axis);
                for (int j = 0; j < shape[axis]; ++j) {
                    rcurrent[axis] = j;
                    rindex.set(rcurrent);
                    r.setDouble(rindex, temp.getDouble(j));
                }
                index.incr();
                ++i;
            }
        }
        return r;
    }
}

