/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.internal.IteratorTransform;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTreeMergeOperator;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutBoundary;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;

public abstract class AbstractRegionBSPTree<P extends Point<P>, N extends AbstractRegionNode<P, N>>
extends AbstractBSPTree<P, N>
implements HyperplaneBoundedRegion<P> {
    private static final RegionCutRule DEFAULT_REGION_CUT_RULE = RegionCutRule.MINUS_INSIDE;
    private static final double UNKNOWN_SIZE = -1.0;
    private double boundarySize = -1.0;
    private RegionSizeProperties<P> regionSizeProperties;

    protected AbstractRegionBSPTree(boolean full) {
        ((AbstractRegionNode)this.getRoot()).setLocationValue(full ? RegionLocation.INSIDE : RegionLocation.OUTSIDE);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasNodeWithLocationRecursive((AbstractRegionNode)this.getRoot(), RegionLocation.INSIDE);
    }

    @Override
    public boolean isFull() {
        return !this.hasNodeWithLocationRecursive((AbstractRegionNode)this.getRoot(), RegionLocation.OUTSIDE);
    }

    private boolean hasNodeWithLocationRecursive(AbstractRegionNode<P, N> node, RegionLocation location) {
        if (node == null) {
            return false;
        }
        return node.getLocation() == location || this.hasNodeWithLocationRecursive((AbstractRegionNode)node.getMinus(), location) || this.hasNodeWithLocationRecursive((AbstractRegionNode)node.getPlus(), location);
    }

    public void setFull() {
        AbstractRegionNode root = (AbstractRegionNode)this.getRoot();
        root.clearCut();
        root.setLocationValue(RegionLocation.INSIDE);
    }

    public void setEmpty() {
        AbstractRegionNode root = (AbstractRegionNode)this.getRoot();
        root.clearCut();
        root.setLocationValue(RegionLocation.OUTSIDE);
    }

    @Override
    public double getSize() {
        return this.getRegionSizeProperties().getSize();
    }

    @Override
    public double getBoundarySize() {
        if (this.boundarySize < 0.0) {
            double sum = 0.0;
            for (AbstractRegionNode node : this.nodes()) {
                RegionCutBoundary boundary = node.getCutBoundary();
                if (boundary == null) continue;
                sum += boundary.getSize();
            }
            this.boundarySize = sum;
        }
        return this.boundarySize;
    }

    public void insert(HyperplaneSubset<P> sub) {
        this.insert(sub, DEFAULT_REGION_CUT_RULE);
    }

    public void insert(HyperplaneSubset<P> sub, RegionCutRule cutRule) {
        this.insert(sub.toConvex(), cutRule);
    }

    public void insert(HyperplaneConvexSubset<P> convexSub) {
        this.insert(convexSub, DEFAULT_REGION_CUT_RULE);
    }

    public void insert(HyperplaneConvexSubset<P> convexSub, RegionCutRule cutRule) {
        this.insert(convexSub, this.getSubtreeInitializer(cutRule));
    }

    public void insert(Iterable<? extends HyperplaneConvexSubset<P>> convexSubs) {
        this.insert(convexSubs, DEFAULT_REGION_CUT_RULE);
    }

    public void insert(Iterable<? extends HyperplaneConvexSubset<P>> convexSubs, RegionCutRule cutRule) {
        for (HyperplaneConvexSubset<P> convexSub : convexSubs) {
            this.insert(convexSub, cutRule);
        }
    }

    public void insert(BoundarySource<? extends HyperplaneConvexSubset<P>> boundarySrc) {
        this.insert(boundarySrc, DEFAULT_REGION_CUT_RULE);
    }

    public void insert(BoundarySource<? extends HyperplaneConvexSubset<P>> boundarySrc, RegionCutRule cutRule) {
        try (Stream<HyperplaneConvexSubset<P>> stream = boundarySrc.boundaryStream();){
            stream.forEach(c -> this.insert((HyperplaneConvexSubset<P>)c, cutRule));
        }
    }

    protected AbstractBSPTree.SubtreeInitializer<N> getSubtreeInitializer(RegionCutRule cutRule) {
        switch (cutRule) {
            case INHERIT: {
                return root -> {
                    RegionLocation rootLoc = root.getLocation();
                    ((AbstractRegionNode)root.getMinus()).setLocationValue(rootLoc);
                    ((AbstractRegionNode)root.getPlus()).setLocationValue(rootLoc);
                };
            }
            case PLUS_INSIDE: {
                return root -> {
                    ((AbstractRegionNode)root.getMinus()).setLocationValue(RegionLocation.OUTSIDE);
                    ((AbstractRegionNode)root.getPlus()).setLocationValue(RegionLocation.INSIDE);
                };
            }
        }
        return root -> {
            ((AbstractRegionNode)root.getMinus()).setLocationValue(RegionLocation.INSIDE);
            ((AbstractRegionNode)root.getPlus()).setLocationValue(RegionLocation.OUTSIDE);
        };
    }

    public Iterable<? extends HyperplaneConvexSubset<P>> boundaries() {
        return this.createBoundaryIterable(Function.identity());
    }

    protected <C extends HyperplaneConvexSubset<P>> Iterable<C> createBoundaryIterable(Function<HyperplaneConvexSubset<P>, C> typeConverter) {
        return () -> new RegionBoundaryIterator(((AbstractRegionNode)this.getRoot()).nodes().iterator(), typeConverter);
    }

    public List<? extends HyperplaneConvexSubset<P>> getBoundaries() {
        return this.createBoundaryList(Function.identity());
    }

    protected <C extends HyperplaneConvexSubset<P>> List<C> createBoundaryList(Function<HyperplaneConvexSubset<P>, C> typeConverter) {
        ArrayList result = new ArrayList();
        RegionBoundaryIterator it = new RegionBoundaryIterator(this.nodes().iterator(), typeConverter);
        it.forEachRemaining(result::add);
        return result;
    }

    @Override
    public P project(P pt) {
        BoundaryProjector projector = new BoundaryProjector(pt);
        this.accept(projector);
        return projector.getProjected();
    }

    @Override
    public P getCentroid() {
        return this.getRegionSizeProperties().getCentroid();
    }

    protected <T extends AbstractRegionBSPTree<P, N>> Split<T> split(Hyperplane<P> splitter, T minus, T plus) {
        this.splitIntoTrees(splitter, minus, plus);
        Object splitMinus = null;
        Object splitPlus = null;
        if (minus != null) {
            ((AbstractRegionNode)((AbstractRegionNode)minus.getRoot()).getPlus()).setLocationValue(RegionLocation.OUTSIDE);
            minus.condense();
            Object v0 = splitMinus = minus.isEmpty() ? null : minus;
        }
        if (plus != null) {
            ((AbstractRegionNode)((AbstractRegionNode)plus.getRoot()).getMinus()).setLocationValue(RegionLocation.OUTSIDE);
            plus.condense();
            splitPlus = plus.isEmpty() ? null : plus;
        }
        return new Split<Object>(splitMinus, splitPlus);
    }

    protected RegionSizeProperties<P> getRegionSizeProperties() {
        if (this.regionSizeProperties == null) {
            this.regionSizeProperties = this.computeRegionSizeProperties();
        }
        return this.regionSizeProperties;
    }

    protected abstract RegionSizeProperties<P> computeRegionSizeProperties();

    @Override
    public RegionLocation classify(P point) {
        if (point.isNaN()) {
            return RegionLocation.OUTSIDE;
        }
        return this.classifyRecursive((AbstractRegionNode)this.getRoot(), point);
    }

    private RegionLocation classifyRecursive(AbstractRegionNode<P, N> node, P point) {
        RegionLocation plusLoc;
        if (node.isLeaf()) {
            return node.getLocation();
        }
        HyperplaneLocation cutLoc = node.getCutHyperplane().classify(point);
        if (cutLoc == HyperplaneLocation.MINUS) {
            return this.classifyRecursive((AbstractRegionNode)node.getMinus(), point);
        }
        if (cutLoc == HyperplaneLocation.PLUS) {
            return this.classifyRecursive((AbstractRegionNode)node.getPlus(), point);
        }
        RegionLocation minusLoc = this.classifyRecursive((AbstractRegionNode)node.getMinus(), point);
        if (minusLoc == (plusLoc = this.classifyRecursive((AbstractRegionNode)node.getPlus(), point))) {
            return minusLoc;
        }
        return RegionLocation.BOUNDARY;
    }

    public void complement() {
        this.complementRecursive((AbstractRegionNode)this.getRoot());
    }

    public void complement(AbstractRegionBSPTree<P, N> tree) {
        this.copySubtree(tree.getRoot(), this.getRoot());
        this.complementRecursive((AbstractRegionNode)this.getRoot());
    }

    private void complementRecursive(AbstractRegionNode<P, N> node) {
        if (node != null) {
            RegionLocation newLoc = node.getLocation() == RegionLocation.INSIDE ? RegionLocation.OUTSIDE : RegionLocation.INSIDE;
            node.setLocationValue(newLoc);
            this.complementRecursive((AbstractRegionNode)node.getMinus());
            this.complementRecursive((AbstractRegionNode)node.getPlus());
        }
    }

    public void union(AbstractRegionBSPTree<P, N> other) {
        new UnionOperator<P, N>().apply(this, other, this);
    }

    public void union(AbstractRegionBSPTree<P, N> a, AbstractRegionBSPTree<P, N> b) {
        new UnionOperator<P, N>().apply(a, b, this);
    }

    public void intersection(AbstractRegionBSPTree<P, N> other) {
        new IntersectionOperator<P, N>().apply(this, other, this);
    }

    public void intersection(AbstractRegionBSPTree<P, N> a, AbstractRegionBSPTree<P, N> b) {
        new IntersectionOperator<P, N>().apply(a, b, this);
    }

    public void difference(AbstractRegionBSPTree<P, N> other) {
        new DifferenceOperator<P, N>().apply(this, other, this);
    }

    public void difference(AbstractRegionBSPTree<P, N> a, AbstractRegionBSPTree<P, N> b) {
        new DifferenceOperator<P, N>().apply(a, b, this);
    }

    public void xor(AbstractRegionBSPTree<P, N> other) {
        new XorOperator<P, N>().apply(this, other, this);
    }

    public void xor(AbstractRegionBSPTree<P, N> a, AbstractRegionBSPTree<P, N> b) {
        new XorOperator<P, N>().apply(a, b, this);
    }

    public boolean condense() {
        return new Condenser().condense((AbstractRegionNode)this.getRoot());
    }

    @Override
    protected void copyNodeProperties(N src, N dst) {
        ((AbstractRegionNode)dst).setLocationValue(((AbstractRegionNode)src).getLocation());
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.boundarySize = -1.0;
        this.regionSizeProperties = null;
    }

    private static final class RegionBoundaryIterator<P extends Point<P>, C extends HyperplaneConvexSubset<P>, N extends AbstractRegionNode<P, N>>
    extends IteratorTransform<N, C> {
        private final Function<? super HyperplaneConvexSubset<P>, C> typeConverter;

        RegionBoundaryIterator(Iterator<N> inputIterator, Function<? super HyperplaneConvexSubset<P>, C> typeConverter) {
            super(inputIterator);
            this.typeConverter = typeConverter;
        }

        @Override
        protected void acceptInput(N input) {
            if (((AbstractBSPTree.AbstractNode)input).isInternal()) {
                RegionCutBoundary cutBoundary = ((AbstractRegionNode)input).getCutBoundary();
                for (HyperplaneConvexSubset boundary : cutBoundary.getOutsideFacing()) {
                    this.addOutput(this.typeConverter.apply(boundary));
                }
                for (HyperplaneConvexSubset boundary : cutBoundary.getInsideFacing()) {
                    HyperplaneConvexSubset reversed = boundary.reverse();
                    this.addOutput(this.typeConverter.apply(reversed));
                }
            }
        }
    }

    private static final class Condenser<P extends Point<P>, N extends AbstractRegionNode<P, N>> {
        private boolean modifiedTree;

        private Condenser() {
        }

        boolean condense(N node) {
            this.modifiedTree = false;
            this.condenseRecursive(node);
            return this.modifiedTree;
        }

        private RegionLocation condenseRecursive(N node) {
            RegionLocation plusLocation;
            if (((AbstractBSPTree.AbstractNode)node).isLeaf()) {
                return ((AbstractRegionNode)node).getLocation();
            }
            RegionLocation minusLocation = this.condenseRecursive((AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus());
            if (minusLocation == (plusLocation = this.condenseRecursive((AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus())) && minusLocation != null) {
                ((AbstractRegionNode)node).setLocationValue(minusLocation);
                ((AbstractRegionNode)node).clearCut();
                this.modifiedTree = true;
                return minusLocation;
            }
            return null;
        }
    }

    private static final class XorOperator<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends RegionMergeOperator<P, N> {
        private XorOperator() {
        }

        @Override
        protected N mergeLeaf(N node1, N node2) {
            if (((AbstractBSPTree.AbstractNode)node1).isLeaf()) {
                if (((AbstractRegionNode)node1).isInside()) {
                    AbstractRegionNode output = (AbstractRegionNode)this.outputSubtree(node2);
                    ((AbstractRegionBSPTree)output.getTree()).complementRecursive(output);
                    return (N)output;
                }
                return node2;
            }
            return this.mergeLeaf(node2, node1);
        }
    }

    private static final class DifferenceOperator<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends RegionMergeOperator<P, N> {
        private DifferenceOperator() {
        }

        @Override
        protected N mergeLeaf(N node1, N node2) {
            if (((AbstractRegionNode)node1).isInside()) {
                AbstractRegionNode output = (AbstractRegionNode)this.outputSubtree(node2);
                ((AbstractRegionBSPTree)output.getTree()).complementRecursive(output);
                return (N)output;
            }
            if (((AbstractRegionNode)node2).isInside()) {
                AbstractRegionNode output = (AbstractRegionNode)this.outputNode();
                output.setLocationValue(RegionLocation.OUTSIDE);
                return (N)output;
            }
            return node1;
        }
    }

    private static final class IntersectionOperator<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends RegionMergeOperator<P, N> {
        private IntersectionOperator() {
        }

        @Override
        protected N mergeLeaf(N node1, N node2) {
            if (((AbstractBSPTree.AbstractNode)node1).isLeaf()) {
                return ((AbstractRegionNode)node1).isInside() ? node2 : node1;
            }
            return this.mergeLeaf(node2, node1);
        }
    }

    private static final class UnionOperator<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends RegionMergeOperator<P, N> {
        private UnionOperator() {
        }

        @Override
        protected N mergeLeaf(N node1, N node2) {
            if (((AbstractBSPTree.AbstractNode)node1).isLeaf()) {
                return ((AbstractRegionNode)node1).isInside() ? node1 : node2;
            }
            return this.mergeLeaf(node2, node1);
        }
    }

    private static abstract class RegionMergeOperator<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends AbstractBSPTreeMergeOperator<P, N> {
        private RegionMergeOperator() {
        }

        public void apply(AbstractRegionBSPTree<P, N> inputTree1, AbstractRegionBSPTree<P, N> inputTree2, AbstractRegionBSPTree<P, N> outputTree) {
            this.performMerge(inputTree1, inputTree2, outputTree);
            outputTree.condense();
        }
    }

    protected static class RegionSizeProperties<P extends Point<P>> {
        private final double size;
        private final P centroid;

        public RegionSizeProperties(double size, P centroid) {
            this.size = size;
            this.centroid = centroid;
        }

        public double getSize() {
            return this.size;
        }

        public P getCentroid() {
            return this.centroid;
        }
    }

    protected static class BoundaryProjector<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends BSPTreeVisitor.ClosestFirstVisitor<P, N> {
        private P projected;
        private double minDist = -1.0;

        public BoundaryProjector(P point) {
            super(point);
        }

        @Override
        public BSPTreeVisitor.Result visit(N node) {
            Object point = this.getTarget();
            if (((AbstractBSPTree.AbstractNode)node).isInternal() && (this.minDist < 0.0 || this.isPossibleClosestCut(((AbstractBSPTree.AbstractNode)node).getCut(), point, this.minDist))) {
                RegionCutBoundary boundary = ((AbstractRegionNode)node).getCutBoundary();
                Object boundaryPt = boundary.closest(point);
                double dist = boundaryPt.distance(point);
                int cmp = Double.compare(dist, this.minDist);
                if (this.minDist < 0.0 || cmp < 0) {
                    this.projected = boundaryPt;
                    this.minDist = dist;
                } else if (cmp == 0) {
                    this.projected = this.disambiguateClosestPoint(point, this.projected, boundaryPt);
                }
            }
            return BSPTreeVisitor.Result.CONTINUE;
        }

        protected boolean isPossibleClosestCut(HyperplaneSubset<P> cut, P target, double currentMinDist) {
            return Math.abs(cut.getHyperplane().offset(target)) <= currentMinDist;
        }

        protected P disambiguateClosestPoint(P target, P a, P b) {
            return a;
        }

        public P getProjected() {
            return this.projected;
        }
    }

    public static abstract class AbstractRegionNode<P extends Point<P>, N extends AbstractRegionNode<P, N>>
    extends AbstractBSPTree.AbstractNode<P, N> {
        private RegionLocation location;
        private RegionCutBoundary<P> cutBoundary;

        protected AbstractRegionNode(AbstractBSPTree<P, N> tree) {
            super(tree);
        }

        @Override
        public AbstractRegionBSPTree<P, N> getTree() {
            return (AbstractRegionBSPTree)super.getTree();
        }

        public RegionLocation getLocation() {
            return this.location;
        }

        public void setLocation(RegionLocation location) {
            if (location != RegionLocation.INSIDE && location != RegionLocation.OUTSIDE) {
                throw new IllegalArgumentException("Invalid node location: " + (Object)((Object)location));
            }
            if (this.location != location) {
                this.location = location;
                ((AbstractRegionBSPTree)this.getTree()).invalidate();
            }
        }

        public boolean isInside() {
            return this.isLeaf() && this.getLocation() == RegionLocation.INSIDE;
        }

        public boolean isOutside() {
            return this.isLeaf() && this.getLocation() == RegionLocation.OUTSIDE;
        }

        public boolean insertCut(Hyperplane<P> cutter) {
            return this.insertCut(cutter, DEFAULT_REGION_CUT_RULE);
        }

        public boolean insertCut(Hyperplane<P> cutter, RegionCutRule cutRule) {
            AbstractBSPTree tree = this.getTree();
            return tree.cutNode(this.getSelf(), cutter, ((AbstractRegionBSPTree)tree).getSubtreeInitializer(cutRule));
        }

        public boolean clearCut() {
            return this.getTree().removeNodeCut(this.getSelf());
        }

        public N cut(Hyperplane<P> cutter) {
            return this.cut(cutter, DEFAULT_REGION_CUT_RULE);
        }

        public N cut(Hyperplane<P> cutter, RegionCutRule cutRule) {
            this.insertCut(cutter, cutRule);
            return (N)((AbstractRegionNode)this.getSelf());
        }

        public RegionCutBoundary<P> getCutBoundary() {
            if (!this.isLeaf()) {
                this.checkValid();
                if (this.cutBoundary == null) {
                    this.cutBoundary = this.computeBoundary();
                }
            }
            return this.cutBoundary;
        }

        private RegionCutBoundary<P> computeBoundary() {
            HyperplaneConvexSubset sub = this.getCut();
            ArrayList minusIn = new ArrayList();
            ArrayList minusOut = new ArrayList();
            this.characterizeHyperplaneSubset(sub, (AbstractRegionNode)this.getMinus(), minusIn, minusOut);
            ArrayList insideFacing = new ArrayList();
            ArrayList outsideFacing = new ArrayList();
            if (!minusIn.isEmpty()) {
                for (HyperplaneConvexSubset minusInFragment : minusIn) {
                    this.characterizeHyperplaneSubset(minusInFragment, (AbstractRegionNode)this.getPlus(), null, outsideFacing);
                }
            }
            if (!minusOut.isEmpty()) {
                for (HyperplaneConvexSubset minusOutFragment : minusOut) {
                    this.characterizeHyperplaneSubset(minusOutFragment, (AbstractRegionNode)this.getPlus(), insideFacing, null);
                }
            }
            insideFacing.trimToSize();
            outsideFacing.trimToSize();
            return new RegionCutBoundary(insideFacing.isEmpty() ? null : insideFacing, outsideFacing.isEmpty() ? null : outsideFacing);
        }

        private void characterizeHyperplaneSubset(HyperplaneConvexSubset<P> sub, AbstractRegionNode<P, N> node, List<? super HyperplaneConvexSubset<P>> in, List<? super HyperplaneConvexSubset<P>> out) {
            if (sub != null) {
                if (node.isLeaf()) {
                    if (node.isInside() && in != null) {
                        in.add(sub);
                    } else if (node.isOutside() && out != null) {
                        out.add(sub);
                    }
                } else {
                    Split<HyperplaneConvexSubset<P>> split = sub.split(node.getCutHyperplane());
                    if (split.getLocation() == SplitLocation.NEITHER) {
                        this.characterizeHyperplaneSubset(sub, (AbstractRegionNode)node.getPlus(), in, out);
                        this.characterizeHyperplaneSubset(sub, (AbstractRegionNode)node.getMinus(), in, out);
                    } else {
                        this.characterizeHyperplaneSubset(split.getPlus(), (AbstractRegionNode)node.getPlus(), in, out);
                        this.characterizeHyperplaneSubset(split.getMinus(), (AbstractRegionNode)node.getMinus(), in, out);
                    }
                }
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[cut= ").append(this.getCut()).append(", location= ").append((Object)this.getLocation()).append("]");
            return sb.toString();
        }

        @Override
        protected void nodeInvalidated() {
            super.nodeInvalidated();
            this.cutBoundary = null;
        }

        protected void setLocationValue(RegionLocation locationValue) {
            this.location = locationValue;
        }
    }
}

